/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.path;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.manager.service.path.PathHandler;

public class PathHandlerImpl
implements PathHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PathHandlerImpl.class);
    private static final Pattern MVN_PROPERTY = Pattern.compile("^\\$\\{(.*)\\}(.*)");
    private static final Pattern INTERPOLATE_P = Pattern.compile("^(\\$\\{(.*)\\}|~|/.:).*");

    protected Path interpolate(String path) {
        Object p = path;
        if (INTERPOLATE_P.matcher(path).matches()) {
            Matcher matcher;
            if (((String)p).startsWith("/") && ((String)p).indexOf(58) == 2) {
                p = ((String)p).substring(1);
            }
            if (((String)p).startsWith("~")) {
                p = System.getProperty("user.home") + ((String)p).substring(1);
            }
            if ((matcher = MVN_PROPERTY.matcher((CharSequence)p)).matches()) {
                String prop = matcher.group(1);
                String value = prop.startsWith("env.") ? System.getenv(prop.substring("env.".length())) : System.getProperty(prop);
                p = value + matcher.group(2);
            }
        }
        try {
            return Paths.get((String)p, new String[0]);
        }
        catch (InvalidPathException e) {
            log.debug("[PathHandlerImpl] not valid path: {}.", p);
            return null;
        }
    }

    protected Path exist(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            return path;
        }
        log.debug("[PathHandlerImpl] non existent path: {}.", (Object)path);
        return null;
    }

    @Override
    public Path get(String path) {
        return this.exist(this.interpolate(path));
    }
}

