/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.internationalization.ParameterBundle;

public class ParameterMeta {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParameterMeta.class);
    private static final ParameterBundle NO_PARAMETER_BUNDLE = new ParameterBundle(null, null, new String[0]){

        protected Optional<String> readValue(String key) {
            return Optional.empty();
        }

        protected Optional<String> readRawValue(String key) {
            return Optional.empty();
        }

        public Optional<String> displayName(ParameterBundle parent) {
            return Optional.empty();
        }

        public Optional<String> placeholder(ParameterBundle parent) {
            return Optional.empty();
        }
    };
    private final Source source;
    private final java.lang.reflect.Type javaType;
    private final Type type;
    private final String path;
    private final String name;
    private final String[] i18nPackages;
    private final List<ParameterMeta> nestedParameters;
    private final Collection<String> proposals;
    private final Map<String, String> metadata;
    private final boolean logMissingResourceBundle;
    private final ConcurrentMap<Locale, ParameterBundle> bundles = new ConcurrentHashMap<Locale, ParameterBundle>();

    public ParameterBundle findBundle(ClassLoader loader, Locale locale) {
        Class type = Optional.of(this.javaType).filter(Class.class::isInstance).map(Class.class::cast).filter(c -> !c.getName().startsWith("java.") && !c.isPrimitive()).orElse(null);
        return this.bundles.computeIfAbsent(locale, l -> {
            try {
                Class<?> declaringClass;
                ResourceBundle[] bundles = (ResourceBundle[])(this.i18nPackages != null ? Stream.of(this.i18nPackages) : Stream.empty()).filter(Objects::nonNull).filter(s -> !s.isEmpty()).distinct().map(p -> p + ".Messages").map(n -> {
                    try {
                        return ResourceBundle.getBundle(n, locale, loader);
                    }
                    catch (MissingResourceException mre) {
                        return null;
                    }
                }).filter(Objects::nonNull).toArray(ResourceBundle[]::new);
                if (bundles.length == 0) {
                    if (this.logMissingResourceBundle) {
                        log.warn(this.noBundleMessage());
                    }
                    return NO_PARAMETER_BUNDLE;
                }
                ArrayList<CallSite> fallbacks = new ArrayList<CallSite>(2);
                Class<?> clazz = declaringClass = this.source == null ? null : this.source.declaringClass();
                if (declaringClass != null && !declaringClass.getName().startsWith("java")) {
                    String sourceName = this.source.name();
                    fallbacks.add((CallSite)((Object)(declaringClass.getName() + "." + sourceName)));
                    if (declaringClass.getEnclosingClass() != null) {
                        fallbacks.add((CallSite)((Object)(declaringClass.getEnclosingClass().getSimpleName() + "$" + declaringClass.getSimpleName() + "." + sourceName)));
                    }
                    fallbacks.add((CallSite)((Object)(declaringClass.getSimpleName() + "." + sourceName)));
                }
                if (type != null) {
                    fallbacks.add((CallSite)((Object)(type.getName() + "." + this.name)));
                    if (type.getEnclosingClass() != null) {
                        fallbacks.add((CallSite)((Object)(type.getEnclosingClass().getSimpleName() + "$" + type.getSimpleName() + "." + this.name)));
                    }
                    fallbacks.add((CallSite)((Object)(type.getSimpleName() + "." + this.name)));
                }
                return new ParameterBundle(bundles, this.path + ".", fallbacks.toArray(new String[fallbacks.size()]));
            }
            catch (MissingResourceException mre) {
                if (this.logMissingResourceBundle) {
                    log.warn(this.noBundleMessage());
                }
                log.debug(mre.getMessage(), (Throwable)mre);
                return NO_PARAMETER_BUNDLE;
            }
        });
    }

    private String noBundleMessage() {
        return (String)(this.i18nPackages == null ? "No bundle " : "No bundle in " + Arrays.asList(this.i18nPackages)) + " (" + this.path + "), means the display names will be the technical names";
    }

    @Generated
    public ParameterMeta(Source source, java.lang.reflect.Type javaType, Type type, String path, String name, String[] i18nPackages, List<ParameterMeta> nestedParameters, Collection<String> proposals, Map<String, String> metadata, boolean logMissingResourceBundle) {
        this.source = source;
        this.javaType = javaType;
        this.type = type;
        this.path = path;
        this.name = name;
        this.i18nPackages = i18nPackages;
        this.nestedParameters = nestedParameters;
        this.proposals = proposals;
        this.metadata = metadata;
        this.logMissingResourceBundle = logMissingResourceBundle;
    }

    @Generated
    public Source getSource() {
        return this.source;
    }

    @Generated
    public java.lang.reflect.Type getJavaType() {
        return this.javaType;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String[] getI18nPackages() {
        return this.i18nPackages;
    }

    @Generated
    public List<ParameterMeta> getNestedParameters() {
        return this.nestedParameters;
    }

    @Generated
    public Collection<String> getProposals() {
        return this.proposals;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public boolean isLogMissingResourceBundle() {
        return this.logMissingResourceBundle;
    }

    @Generated
    public ConcurrentMap<Locale, ParameterBundle> getBundles() {
        return this.bundles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterMeta)) {
            return false;
        }
        ParameterMeta other = (ParameterMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLogMissingResourceBundle() != other.isLogMissingResourceBundle()) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        java.lang.reflect.Type this$javaType = this.getJavaType();
        java.lang.reflect.Type other$javaType = other.getJavaType();
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getI18nPackages(), other.getI18nPackages())) {
            return false;
        }
        List<ParameterMeta> this$nestedParameters = this.getNestedParameters();
        List<ParameterMeta> other$nestedParameters = other.getNestedParameters();
        if (this$nestedParameters == null ? other$nestedParameters != null : !((Object)this$nestedParameters).equals(other$nestedParameters)) {
            return false;
        }
        Collection<String> this$proposals = this.getProposals();
        Collection<String> other$proposals = other.getProposals();
        if (this$proposals == null ? other$proposals != null : !((Object)this$proposals).equals(other$proposals)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ConcurrentMap<Locale, ParameterBundle> this$bundles = this.getBundles();
        ConcurrentMap<Locale, ParameterBundle> other$bundles = other.getBundles();
        return !(this$bundles == null ? other$bundles != null : !this$bundles.equals(other$bundles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParameterMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLogMissingResourceBundle() ? 79 : 97);
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        java.lang.reflect.Type $javaType = this.getJavaType();
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getI18nPackages());
        List<ParameterMeta> $nestedParameters = this.getNestedParameters();
        result = result * 59 + ($nestedParameters == null ? 43 : ((Object)$nestedParameters).hashCode());
        Collection<String> $proposals = this.getProposals();
        result = result * 59 + ($proposals == null ? 43 : ((Object)$proposals).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ConcurrentMap<Locale, ParameterBundle> $bundles = this.getBundles();
        result = result * 59 + ($bundles == null ? 43 : $bundles.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParameterMeta(type=" + this.getType() + ", path=" + this.getPath() + ", name=" + this.getName() + ", metadata=" + this.getMetadata() + ")";
    }

    public static interface Source {
        public String name();

        public Class<?> declaringClass();
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        BOOLEAN,
        STRING,
        NUMBER,
        ENUM;

    }
}

