/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http.codec;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CodecMatcher<T> {
    private final ConcurrentMap<String, T> cache = new ConcurrentHashMap<String, T>();

    public T select(Map<String, T> codecList, String contentType) {
        String mediaType = this.extractMediaType(contentType);
        return (T)this.cache.computeIfAbsent(mediaType, k -> {
            if (codecList.containsKey(mediaType)) {
                return codecList.get(mediaType);
            }
            Optional<Object> matched = codecList.entrySet().stream().filter(e -> mediaType.matches(((String)e.getKey()).replace("+", "\\+").replace("*", ".+"))).findFirst().map(Map.Entry::getValue);
            return matched.orElseThrow(() -> new IllegalStateException("No codec found for content-type: '" + contentType + "'"));
        });
    }

    private String extractMediaType(String contentType) {
        if (contentType == null || contentType.isEmpty()) {
            return "*/*";
        }
        return (contentType.contains(";") ? contentType.split(";")[0] : contentType).toLowerCase(Locale.ROOT);
    }
}

