/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http.codec;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import lombok.Generated;
import org.talend.sdk.component.api.service.http.Decoder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXBDecoder
implements Decoder {
    private final Map<Class<?>, JAXBContext> jaxbContexts;

    public Object decode(byte[] value, Type expectedType) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            Class key = (Class)Class.class.cast(expectedType);
            return this.jaxbContexts.get(key).createUnmarshaller().unmarshal((Source)new SAXSource(xmlReader, new InputSource(new ByteArrayInputStream(value))), key).getValue();
        }
        catch (JAXBException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Generated
    public JAXBDecoder(Map<Class<?>, JAXBContext> jaxbContexts) {
        this.jaxbContexts = jaxbContexts;
    }
}

