/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class SimpleQueryLanguageCompiler {
    private static final BiPredicate<String, String> EQUAL_PREDICATE = new EqualPredicate();
    private static final BiPredicate<String, String> DIFFERENT_PREDICATE = new DifferentPredicate();

    public <T> Predicate<T> compile(String query, Map<String, Function<T, Object>> evaluators) {
        if (query == null || query.trim().isEmpty()) {
            return t -> true;
        }
        return ((SubExpression)this.doCompile(query.toCharArray(), 0, evaluators, TokenType.END)).predicate;
    }

    public <T> SubExpression<T> doCompile(char[] buffer, int from, Map<String, Function<T, Object>> evaluators, TokenType stopToken) {
        Token token;
        Predicate predicate = null;
        BinaryOperator combiner = null;
        int index = from;
        while (stopToken != (token = this.nextToken(buffer, index)).type) {
            index = this.moveIndex(buffer, token, true);
            block0 : switch (token.type) {
                case VALUE: {
                    Token opToken = this.nextToken(buffer, index);
                    if (opToken.type != TokenType.OPERATOR) {
                        throw new IllegalArgumentException("Expected an operator after token '" + token.value + "' at index " + token.end);
                    }
                    index = this.moveIndex(buffer, opToken, true);
                    Token expectedValueToken = this.nextToken(buffer, index);
                    if (expectedValueToken.type == TokenType.VALUE) {
                        index = this.moveIndex(buffer, expectedValueToken, false);
                        Predicate expr = this.toPredicate(token.value, opToken.value, expectedValueToken.value, evaluators);
                        this.validateCombiner(predicate, combiner, token);
                        predicate = predicate == null ? expr : (Predicate)combiner.apply(predicate, expr);
                        combiner = null;
                        break;
                    }
                    throw new IllegalArgumentException("Unsupported token: " + (Object)((Object)token.type) + " at index " + token.end);
                }
                case SUB_EXPRESSION_START: {
                    SubExpression<T> expr = this.doCompile(buffer, index, evaluators, TokenType.SUB_EXPRESSION_END);
                    this.validateCombiner(predicate, combiner, token);
                    predicate = predicate == null ? ((SubExpression)expr).predicate : (Predicate)combiner.apply(predicate, ((SubExpression)expr).predicate);
                    combiner = null;
                    index = ((SubExpression)expr).end + 1;
                    break;
                }
                case COMBINER: {
                    switch (token.value) {
                        case "AND": {
                            combiner = Predicate::and;
                            break block0;
                        }
                        case "OR": {
                            combiner = Predicate::or;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported combiner operator: " + (Object)((Object)token.type) + " at index " + token.end + ", expected 'OR' or 'AND'");
                }
                default: {
                    throw new IllegalArgumentException("Unsupported token: " + (Object)((Object)token.type) + " at index " + token.end);
                }
            }
        }
        return new SubExpression<Object>(index, predicate == null ? t -> true : predicate);
    }

    private <T> void validateCombiner(Predicate<T> predicate, BinaryOperator<Predicate<T>> combiner, Token token) {
        if (combiner == null && predicate != null) {
            throw new IllegalArgumentException("Missing combiner for predicate at index " + token.end);
        }
    }

    private int moveIndex(char[] buffer, Token token, boolean validate) {
        int index = token.end + 1;
        if (validate && index >= buffer.length) {
            throw new IllegalArgumentException("Unexpected token '" + token + "' at index " + token.end);
        }
        return index;
    }

    private <T> Predicate<T> toPredicate(String key, String operator, String expectedValue, Map<String, Function<T, Object>> evaluators) {
        int endMapAccess;
        BiPredicate<String, String> comparator;
        switch (operator) {
            case "=": {
                comparator = EQUAL_PREDICATE;
                break;
            }
            case "!=": {
                comparator = DIFFERENT_PREDICATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown operator: '" + operator + "'");
            }
        }
        int mapExpr = key.indexOf(91);
        if (mapExpr > 0 && (endMapAccess = key.indexOf(93, mapExpr)) > 0) {
            String mapName = key.substring(0, mapExpr);
            String mapKey = key.substring(mapExpr + 1, endMapAccess);
            Function evaluator = Optional.ofNullable(evaluators.get(mapName)).orElseThrow(() -> new IllegalArgumentException("Missing evaluator for '" + mapName + "'"));
            return new ComparePredicate<Object>(comparator, t -> {
                Object map = evaluator.apply(t);
                if (!Map.class.isInstance(map)) {
                    throw new IllegalArgumentException(map + " is not a map");
                }
                return ((Map)Map.class.cast(map)).get(mapKey);
            }, expectedValue);
        }
        Function<T, Object> evaluator = Optional.ofNullable(evaluators.get(key)).orElseThrow(() -> new IllegalArgumentException("Missing evaluator for '" + key + "'"));
        return new ComparePredicate<T>(comparator, evaluator, expectedValue);
    }

    private Token nextToken(char[] buffer, int from) {
        if (from >= buffer.length) {
            return new Token(from, TokenType.END, null);
        }
        int actualFrom = from;
        int idx = from;
        block16: while (idx < buffer.length) {
            switch (buffer[idx]) {
                case '(': {
                    if (from == idx) {
                        return new Token(idx, TokenType.SUB_EXPRESSION_START, null);
                    }
                    return new Token(idx - 1, TokenType.VALUE, new String(buffer, actualFrom, idx - actualFrom));
                }
                case ')': {
                    if (from == idx) {
                        return new Token(idx, TokenType.SUB_EXPRESSION_END, null);
                    }
                    return new Token(idx - 1, TokenType.VALUE, new String(buffer, actualFrom, idx - actualFrom));
                }
                case ' ': {
                    String string;
                    if (idx == from) {
                        ++idx;
                        actualFrom = from + 1;
                        continue block16;
                    }
                    switch (string = new String(buffer, actualFrom, idx - actualFrom)) {
                        case "AND": 
                        case "OR": {
                            return new Token(idx, TokenType.COMBINER, string);
                        }
                    }
                    return new Token(idx, TokenType.VALUE, string);
                }
                case '=': {
                    return new Token(idx, TokenType.OPERATOR, "=");
                }
                case '!': {
                    if (++idx >= buffer.length || buffer[idx] != '=') continue block16;
                    return new Token(idx, TokenType.OPERATOR, "!=");
                }
                case 'A': {
                    if (idx == from && idx + 3 < buffer.length && buffer[idx + 1] == 'N' && buffer[idx + 2] == 'D' && buffer[idx + 3] == ' ') {
                        return new Token(idx += 3, TokenType.COMBINER, "AND");
                    }
                    ++idx;
                    continue block16;
                }
                case 'O': {
                    if (idx == from && idx + 2 < buffer.length && buffer[idx + 1] == 'R' && buffer[idx + 2] == ' ') {
                        return new Token(idx += 2, TokenType.COMBINER, "OR");
                    }
                    ++idx;
                    continue block16;
                }
            }
            ++idx;
        }
        return new Token(idx, TokenType.VALUE, new String(buffer, actualFrom, buffer.length - actualFrom));
    }

    private static enum TokenType {
        SUB_EXPRESSION_START,
        SUB_EXPRESSION_END,
        VALUE,
        OPERATOR,
        COMBINER,
        END;

    }

    private static class SubExpression<T> {
        private final int end;
        private final Predicate<T> predicate;

        public String toString() {
            return "SimpleQueryLanguageCompiler.SubExpression(end=" + this.end + ", predicate=" + this.predicate + ")";
        }

        public SubExpression(int end, Predicate<T> predicate) {
            this.end = end;
            this.predicate = predicate;
        }
    }

    private static class Token {
        private final int end;
        private final TokenType type;
        private final String value;

        public String toString() {
            return "SimpleQueryLanguageCompiler.Token(end=" + this.end + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + ")";
        }

        public Token(int end, TokenType type, String value) {
            this.end = end;
            this.type = type;
            this.value = value;
        }
    }

    private class ComparePredicate<T>
    implements Predicate<T> {
        private final BiPredicate<String, String> comparator;
        private final Function<T, Object> evaluator;
        private final String expectedValue;

        @Override
        public boolean test(T t) {
            return this.comparator.test(String.valueOf(this.evaluator.apply(t)), this.expectedValue);
        }

        public ComparePredicate(BiPredicate<String, String> comparator, Function<T, Object> evaluator, String expectedValue) {
            this.comparator = comparator;
            this.evaluator = evaluator;
            this.expectedValue = expectedValue;
        }
    }

    private static class EqualPredicate
    implements BiPredicate<String, String> {
        private EqualPredicate() {
        }

        @Override
        public boolean test(String v1, String v2) {
            return v1 == null && "null".equals(v2) || Objects.equals(v1, v2);
        }
    }

    private static class DifferentPredicate
    implements BiPredicate<String, String> {
        private DifferentPredicate() {
        }

        @Override
        public boolean test(String v1, String v2) {
            return !EQUAL_PREDICATE.test(v1, v2);
        }
    }
}

