/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.security;

import java.io.IOException;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.security.event.OnConnection;

@Provider
@Dependent
@PreMatching
public class ConnectionSecurityProvider
implements ContainerRequestFilter {
    public static final String SKIP = ConnectionSecurityProvider.class.getName() + ".skip";
    @Context
    private HttpServletRequest request;
    @Inject
    private Event<OnConnection> onConnectionEvent;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (Boolean.TRUE.equals(this.request.getAttribute(SKIP))) {
            return;
        }
        OnConnection onConnection = new OnConnection();
        this.onConnectionEvent.fire((Object)onConnection);
        if (!onConnection.isValid()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorPayload(ErrorDictionary.UNAUTHORIZED, "Invalid connection credentials")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

