/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service.security;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.EventContext;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import javax.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.service.security.event.OnCommand;
import org.talend.sdk.component.server.service.security.event.OnConnection;

public class SecurityExtension
implements Extension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityExtension.class);
    private final Map<String, ObserverMethod<OnConnection>> onConnectionObservers = new HashMap<String, ObserverMethod<OnConnection>>();
    private final Map<String, ObserverMethod<OnCommand>> onCommandObservers = new HashMap<String, ObserverMethod<OnCommand>>();
    private ObserverMethod<OnConnection> onConnectionMtd;
    private ObserverMethod<OnCommand> onCommandMtd;

    void findOnConnectionMethod(@Observes ProcessObserverMethod<OnConnection, ?> processObserverMethod) {
        if (ProcessSyntheticObserverMethod.class.isInstance(processObserverMethod)) {
            return;
        }
        this.onConnectionObservers.put(this.getName(processObserverMethod), (ObserverMethod<OnConnection>)processObserverMethod.getObserverMethod());
        processObserverMethod.veto();
    }

    void findOnCommandMethod(@Observes ProcessObserverMethod<OnCommand, ?> processObserverMethod) {
        if (ProcessSyntheticObserverMethod.class.isInstance(processObserverMethod)) {
            return;
        }
        this.onCommandObservers.put(this.getName(processObserverMethod), (ObserverMethod<OnCommand>)processObserverMethod.getObserverMethod());
        processObserverMethod.veto();
    }

    void addSecurityHandlerObservers(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ObserverMethodConfigurator onConnection = afterBeanDiscovery.addObserverMethod();
        onConnection.observedType(OnConnection.class).notifyWith(this::onConnection);
        ObserverMethodConfigurator onCommand = afterBeanDiscovery.addObserverMethod();
        onCommand.observedType(OnCommand.class).notifyWith(this::onCommand);
    }

    void bindSecurityHandlers(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        ComponentServerConfiguration configuration = (ComponentServerConfiguration)ComponentServerConfiguration.class.cast(beanManager.getReference(beanManager.resolve(beanManager.getBeans(ComponentServerConfiguration.class, new Annotation[0])), ComponentServerConfiguration.class, beanManager.createCreationalContext(null)));
        String connectionHandler = configuration.getSecurityConnectionHandler();
        this.onConnectionMtd = Optional.ofNullable(this.onConnectionObservers.get(connectionHandler)).orElseThrow(() -> new IllegalArgumentException("No handler '" + connectionHandler + "'"));
        String commandHandler = configuration.getSecurityCommandHandler();
        this.onCommandMtd = Optional.ofNullable(this.onCommandObservers.get(commandHandler)).orElseThrow(() -> new IllegalArgumentException("No handler '" + commandHandler + "'"));
        this.onConnectionObservers.clear();
        this.onCommandObservers.clear();
        log.info("Security configured with connection handler '{}' and command handler '{}'", (Object)connectionHandler, (Object)commandHandler);
    }

    private void onConnection(EventContext<OnConnection> onConnection) {
        this.onConnectionMtd.notify(onConnection);
    }

    private void onCommand(EventContext<OnCommand> onCommand) {
        this.onCommandMtd.notify(onCommand);
    }

    private String getName(ProcessObserverMethod<?, ?> processObserverMethod) {
        return Optional.ofNullable((Named)processObserverMethod.getAnnotatedMethod().getDeclaringType().getAnnotation(Named.class)).map(Named::value).orElseGet(() -> processObserverMethod.getAnnotatedMethod().getJavaMember().getName());
    }
}

