/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tools.blackduck;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;

public abstract class BlackduckBase
extends AbstractMojo {
    @Parameter(property="hub-detect.serverId", defaultValue="blackduck")
    protected String serverId;
    @Parameter(property="hub-detect.blackduckUrl")
    protected String blackduckUrl;
    @Parameter(property="hub-detect.blackduckName", defaultValue="${project.name}")
    protected String blackduckName;
    @Parameter(property="hub-detect.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="hub-detect.atTheEnd", defaultValue="true")
    protected boolean atTheEnd;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Component
    protected SettingsDecrypter settingsDecrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AtomicInteger counter = (AtomicInteger)AtomicInteger.class.cast(this.session.getRequest().getData().computeIfAbsent(((Object)((Object)this)).getClass().getName() + ".counter", k -> new AtomicInteger()));
        if (this.atTheEnd && !this.skip && counter.incrementAndGet() != this.reactorProjects.size()) {
            this.getLog().debug((CharSequence)String.format("Not yet at the last project, will only run when reached to not do it multiple times %d/%d", counter.get(), this.reactorProjects.size()));
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution is skipped");
            return;
        }
        MavenProject rootProject = this.session.getCurrentProject();
        while (rootProject.getParent() != null) {
            rootProject = rootProject.getParent();
        }
        if (this.session.getSettings().isOffline()) {
            this.getLog().info((CharSequence)"Execution is offline, blackduck hub-detect plugin is skipped");
            return;
        }
        if (this.blackduckUrl == null) {
            this.getLog().error((CharSequence)"No url specified, please set blackduckUrl");
            return;
        }
        Optional<Server> serverOpt = this.session.getSettings().getServers().stream().filter(s -> this.serverId.equals(s.getId())).findFirst();
        if (!serverOpt.isPresent()) {
            this.getLog().warn((CharSequence)String.format("No server '%s', skipping blackduck execution", this.serverId));
            return;
        }
        Server tmpServer = serverOpt.get();
        Server server = Optional.ofNullable(this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(tmpServer)).getServer()).orElse(tmpServer);
        if ("skip".equals(server.getPassword())) {
            this.getLog().warn((CharSequence)String.format("server '%s' was configured to be skipped", this.serverId));
            return;
        }
        this.doExecute(rootProject, server);
    }

    protected abstract void doExecute(MavenProject var1, Server var2) throws MojoExecutionException, MojoFailureException;
}

