/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tools.blackduck;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.CredentialsBuilder;
import com.blackducksoftware.integration.hub.api.report.AggregateBomViewEntry;
import com.blackducksoftware.integration.hub.api.report.ReportCategoriesEnum;
import com.blackducksoftware.integration.hub.api.report.ReportRequestService;
import com.blackducksoftware.integration.hub.api.report.VersionReport;
import com.blackducksoftware.integration.hub.dataservice.project.ProjectDataService;
import com.blackducksoftware.integration.hub.dataservice.project.ProjectVersionWrapper;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.hub.model.enumeration.ReportFormatEnum;
import com.blackducksoftware.integration.hub.proxy.ProxyInfoBuilder;
import com.blackducksoftware.integration.hub.rest.CredentialsRestConnection;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubServicesFactory;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.log.Slf4jIntLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.ToIntFunction;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.slf4j.LoggerFactory;
import org.talend.tools.blackduck.BlackduckBase;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class BlackduckValidateMojo
extends BlackduckBase {
    @Parameter(property="hub-detect.alwaysTrustServerCertificate", defaultValue="false")
    private boolean alwaysTrustServerCertificate;
    @Parameter(property="hub-detect.acceptedOperationalHigh", defaultValue="0")
    private int acceptedOperationalHigh;
    @Parameter(property="hub-detect.acceptedLicenseRiskHigh", defaultValue="0")
    private int acceptedLicenseRiskHigh;
    @Parameter(property="hub-detect.acceptedVulerabilityRiskHigh", defaultValue="0")
    private int acceptedVulerabilityRiskHigh;

    @Override
    public void doExecute(MavenProject mvnProject, Server credentials) throws MojoExecutionException, MojoFailureException {
        VersionReport report;
        ProjectVersionWrapper project;
        ReportRequestService reportService;
        block13: {
            CredentialsRestConnection restConnection;
            CredentialsBuilder credentialsBuilder = new CredentialsBuilder();
            credentialsBuilder.setUsername(credentials.getUsername());
            credentialsBuilder.setPassword(credentials.getPassword());
            this.alwaysTrustServerCertificate = true;
            try {
                restConnection = new HubServerConfig(new URL(this.blackduckUrl), 60, credentialsBuilder.buildObject(), new ProxyInfoBuilder().buildObject(), this.alwaysTrustServerCertificate).createCredentialsRestConnection((IntLogger)new Slf4jIntLogger(LoggerFactory.getLogger((String)"client")));
            }
            catch (EncryptionException | MalformedURLException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            HubServicesFactory hsf = new HubServicesFactory((RestConnection)restConnection);
            reportService = hsf.createReportRequestService(60000L);
            ProjectDataService projectService = hsf.createProjectDataService();
            try {
                project = projectService.getProjectVersion(this.blackduckName, mvnProject.getVersion());
            }
            catch (IntegrationException e) {
                if (!mvnProject.getVersion().endsWith("-SNAPSHOT")) {
                    try {
                        project = projectService.getProjectVersion(this.blackduckName, mvnProject.getVersion() + "-SNAPSHOT");
                    }
                    catch (IntegrationException e1) {
                        try {
                            project = projectService.getProjectVersionAndCreateIfNeeded(this.blackduckName, mvnProject.getVersion());
                            break block13;
                        }
                        catch (IntegrationException e2) {
                            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                        }
                    }
                }
                try {
                    project = projectService.getProjectVersionAndCreateIfNeeded(this.blackduckName, mvnProject.getVersion());
                }
                catch (IntegrationException e2) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        try {
            report = reportService.generateHubReport(project.getProjectVersionView(), ReportFormatEnum.JSON, new ReportCategoriesEnum[]{ReportCategoriesEnum.COMPONENTS});
        }
        catch (IntegrationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.validate(report, "operational", it -> it.getRiskProfile().getCategories().getOPERATIONAL().getHIGH(), this.acceptedOperationalHigh);
        this.validate(report, "license", it -> it.getLicenseRisk().getHIGH(), this.acceptedLicenseRiskHigh);
        this.validate(report, "vulnerability", it -> it.getVulnerabilityRisk().getHIGH(), this.acceptedVulerabilityRiskHigh);
    }

    private void validate(VersionReport report, String what, ToIntFunction<AggregateBomViewEntry> mapper, int limit) throws MojoFailureException {
        int count = report.getAggregateBomViewEntries().stream().mapToInt(mapper).sum();
        if (count > limit) {
            String message = String.format("Found #%d %s high violations, accepted: #%d", count, what, limit);
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }
}

