/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tools.blackduck;

import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.shared.artifact.deploy.ArtifactDeployer;
import org.apache.maven.shared.artifact.deploy.ArtifactDeployerException;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.talend.tools.blackduck.BlackduckBase;

@Mojo(name="hub-detect", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class HubDetectMojo
extends BlackduckBase {
    private static final String OLD_HUB_DETECT = "com.blackducksoftware.integration:hub-detect:5.2.0";
    @Parameter(property="hub-detect.hubDetectCache", defaultValue="${project.build.directory}/blackduck/synopsys-detect.jar")
    private File hubDetectCache;
    @Parameter(property="hub-detect.hubDetectCache", defaultValue="${project.build.directory}/blackduck/scan-cli")
    private File scanCliCache;
    @Parameter(property="hub-detect.artifactoryBase", defaultValue="https://repo.blackducksoftware.com/artifactory")
    private String artifactoryBase;
    @Parameter(property="hub-detect.latestVersionUrl", defaultValue="%s/api/search/latestVersion?g=%s&a=%s&repos=%s")
    private String latestVersionUrl;
    @Parameter(property="hub-detect.executableGav", defaultValue="com.synopsys.integration:synopsys-detect:latest")
    private String executableGav;
    @Parameter(property="hub-detect.scanCliDownloadUrl", defaultValue="https://blackduck.talend.com/download/scan.cli.zip")
    private String scanCliDownloadUrl;
    @Parameter(property="hub-detect.scanCliOffline", defaultValue="false")
    private boolean scanCliOffline;
    @Parameter(property="hub-detect.scanCliGav", defaultValue="com.blackducksoftware.integration:scan-cli:latest")
    private String scanCliGav;
    @Parameter(property="hub-detect.forceScanCliDownload", defaultValue="false")
    private boolean forceScanCliDownload;
    @Parameter(property="hub-detect.artifactRepositoryName", defaultValue="bds-integrations-release")
    private String artifactRepositoryName;
    @Parameter(property="hub-detect.logLevel", defaultValue="INFO")
    private String logLevel;
    @Parameter(property="hub-detect.validateExitCode", defaultValue="0")
    private String validateExitCode;
    @Parameter(property="hub-detect.scope", defaultValue="runtime")
    private String scope;
    @Parameter
    private Map<String, String> systemVariables;
    @Parameter
    private Collection<String> jvmOptions;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private Collection<String> args;
    @Parameter
    private Collection<String> exclusions;
    @Component
    private ArtifactResolver resolver;
    @Component
    private ArtifactDeployer deployer;

    @Override
    public void doExecute(MavenProject rootProject, Server server) throws MojoExecutionException, MojoFailureException {
        int expectedExitCode;
        int exitStatus;
        File explodedScanCli;
        String hubDetectVersion;
        if (this.blackduckName == null) {
            this.getLog().error((CharSequence)"No name specified, please set blackduckName");
            return;
        }
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(rootProject.getRemoteProjectRepositories().size() + 1);
        repositories.add(new RemoteRepository.Builder("blackduck_" + ((Object)((Object)this)).getClass().getName(), "default", this.artifactoryBase + '/' + this.artifactRepositoryName).build());
        repositories.addAll(rootProject.getRemoteProjectRepositories());
        File jar = null;
        String[] gav = this.executableGav.split(":");
        if (!this.hubDetectCache.exists()) {
            hubDetectVersion = this.getHubDetectVersion(gav);
            this.hubDetectCache.getParentFile().mkdirs();
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    this.getLog().info((CharSequence)("Using old blackduck hub-detect gav cause " + this.executableGav + " was not found"));
                    gav = OLD_HUB_DETECT.split(":");
                }
                try {
                    ArtifactResult artifactResult = this.resolver.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest((Artifact)new DefaultArtifact(gav[0], gav[1], "jar", hubDetectVersion), repositories, null));
                    if (artifactResult.isMissing() && i == 1) {
                        throw new IllegalStateException(String.format("Didn't find '%s'", this.executableGav));
                    }
                    jar = artifactResult.getArtifact().getFile();
                    break;
                }
                catch (ArtifactResolutionException e2) {
                    if (i != 1) continue;
                    throw new IllegalStateException(String.format("Didn't find '%s'", this.executableGav), e2);
                }
            }
            try {
                FileUtils.copyFile(jar, (File)this.hubDetectCache);
            }
            catch (IOException e3) {
                throw new IllegalStateException(e3);
            }
        } else {
            hubDetectVersion = this.getHubDetectVersion(gav);
        }
        if (this.scanCliOffline) {
            String[] gav2 = this.scanCliGav.split(":");
            if (!this.scanCliCache.exists()) {
                File scanCliZip;
                boolean downloaded = false;
                if (this.forceScanCliDownload) {
                    downloaded = true;
                    scanCliZip = this.downloadScanCli(rootProject);
                } else {
                    try {
                        ArtifactResult artifactResult = this.resolver.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest((Artifact)new DefaultArtifact(gav2[0], gav2[1], "zip", hubDetectVersion), Collections.emptyList(), null));
                        if (artifactResult.isMissing()) {
                            downloaded = true;
                            scanCliZip = this.downloadScanCli(rootProject);
                        } else {
                            scanCliZip = artifactResult.getArtifact().getFile();
                        }
                    }
                    catch (ArtifactResolutionException e4) {
                        scanCliZip = this.downloadScanCli(rootProject);
                        downloaded = true;
                    }
                }
                if (downloaded) {
                    try {
                        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(gav2[0], gav2[1], hubDetectVersion, "compile", "zip", null, (ArtifactHandler)new DefaultArtifactHandler("zip"));
                        artifact.setFile(scanCliZip);
                        this.deployer.deploy(this.session.getProjectBuildingRequest(), this.session.getLocalRepository(), Collections.singletonList(artifact));
                    }
                    catch (ArtifactDeployerException e5) {
                        throw new MojoExecutionException(e5.getMessage(), (Exception)((Object)e5));
                    }
                }
                try {
                    FileUtils.copyFile((File)scanCliZip, (File)this.scanCliCache);
                }
                catch (IOException e6) {
                    throw new IllegalStateException(e6);
                }
            }
            if (!(explodedScanCli = new File(rootProject.getBuild().getDirectory(), "blackduck/" + ((Object)((Object)this)).getClass().getSimpleName() + "_scancli")).exists()) {
                this.unzip(this.scanCliCache, explodedScanCli, true);
            }
        } else {
            explodedScanCli = null;
        }
        boolean useArgs = this.shouldUseArgs(hubDetectVersion);
        String rootPath = rootProject.getBasedir().getAbsolutePath();
        File java = new File(System.getProperty("java.home"), "bin/java");
        ArrayList<String> command = new ArrayList<String>();
        command.add(java.getAbsolutePath());
        if (this.jvmOptions != null) {
            command.addAll(this.jvmOptions);
        }
        if (this.systemVariables != null && !useArgs) {
            command.addAll(this.systemVariables.entrySet().stream().map(e -> String.format("-D%s=%s", e.getKey(), this.handlePlaceholders(rootPath, (String)e.getValue()))).collect(Collectors.toList()));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).inheritIO().command(command);
        Map<String, String> environment = processBuilder.environment();
        if (this.environment != null) {
            environment.putAll(this.environment);
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("blackduck.hub.url", this.blackduckUrl);
        config.put("blackduck.hub.username", server.getUsername());
        config.put("blackduck.hub.password", server.getPassword());
        config.put("logging.level.com.blackducksoftware.integration", this.logLevel);
        config.put("detect.project.name", this.blackduckName);
        config.put("detect.source.path", rootPath);
        config.put("detect.maven.scope", this.scope);
        if (this.scanCliOffline) {
            config.put("detect.hub.signature.scanner.offline.local.path", explodedScanCli.getAbsolutePath());
        }
        if (this.systemVariables == null || !this.systemVariables.containsKey("detect.output.path")) {
            config.put("detect.output.path", new File(rootProject.getBuild().getDirectory(), "blackduck").getAbsolutePath());
        }
        String enforcedExcluded = "/blackduck/";
        if (this.exclusions != null) {
            config.put("detect.hub.signature.scanner.exclusion.patterns", Stream.concat(Stream.of("/blackduck/"), this.exclusions.stream().filter(Objects::nonNull).map(String::trim)).collect(Collectors.joining(",")));
        } else {
            config.put("detect.hub.signature.scanner.exclusion.patterns", "/blackduck/");
        }
        if (this.systemVariables != null && useArgs) {
            config.putAll(this.systemVariables);
        }
        if (!useArgs) {
            environment.put("SPRING_APPLICATION_JSON", new GsonBuilder().create().toJson(config));
        }
        command.add("-jar");
        command.add(this.hubDetectCache.getAbsolutePath());
        if (this.args != null) {
            command.addAll(this.args);
        }
        if (useArgs) {
            command.addAll(config.entrySet().stream().map(it -> "--" + ((String)it.getKey()).replace("blackduck.hub.", "blackduck.").replace("detect.hub.", "detect.blackduck.") + "=" + (String)it.getValue()).collect(Collectors.toList()));
        }
        this.getLog().info((CharSequence)("Launching: " + processBuilder.command()));
        try {
            exitStatus = processBuilder.start().waitFor();
        }
        catch (InterruptedException e7) {
            Thread.currentThread().interrupt();
            this.getLog().error((Throwable)e7);
            throw new IllegalStateException(e7);
        }
        catch (IOException e8) {
            this.getLog().error((Throwable)e8);
            throw new IllegalStateException(e8);
        }
        this.getLog().info((CharSequence)String.format("Output: %d", exitStatus));
        try {
            expectedExitCode = Integer.parseInt(this.validateExitCode);
        }
        catch (NumberFormatException nfe) {
            if (Boolean.parseBoolean(this.validateExitCode)) {
                expectedExitCode = 0;
            }
            return;
        }
        if (exitStatus != expectedExitCode) {
            throw new IllegalStateException(String.format("Invalid exit status: %d", exitStatus));
        }
    }

    private boolean shouldUseArgs(String hubDetectVersion) {
        try {
            return Integer.parseInt(hubDetectVersion.split("\\.")[0]) > 4;
        }
        catch (NumberFormatException nfe) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadScanCli(MavenProject rootProject) {
        this.getLog().info((CharSequence)"Downloading scan.cli.zip, can take some time...\r");
        try {
            URL url = new URL(this.scanCliDownloadUrl);
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
            File zip = new File(rootProject.getBuild().getDirectory(), "blackduck/" + ((Object)((Object)this)).getClass().getSimpleName() + "/scan.cli.zip");
            zip.getParentFile().mkdirs();
            int bufferSize = 819200;
            long downloaded = 0L;
            long start = System.nanoTime();
            long length = connection.getContentLengthLong();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(zip), 819200);){
                int read;
                byte[] buffer = new byte[819200];
                int percentage = -1;
                InputStream inputStream = connection.getInputStream();
                while ((read = inputStream.read(buffer)) >= 0) {
                    downloaded += (long)read;
                    if (read <= 0) continue;
                    ((OutputStream)os).write(buffer, 0, read);
                    float value = (float)downloaded * 1.0f / (float)length;
                    int pcTracker = (int)(value * 100.0f);
                    if (percentage == pcTracker) continue;
                    System.out.printf("Downloading scan.cli.zip - %2.2f%%\r", Float.valueOf(value));
                    System.out.flush();
                    percentage = pcTracker;
                }
            }
            finally {
                connection.disconnect();
            }
            long end = System.nanoTime();
            this.getLog().info((CharSequence)String.format("Downloaded scan.cli.zip in %d seconds", TimeUnit.NANOSECONDS.toSeconds(end - start)));
            return zip;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getHubDetectVersion(String[] gav) {
        if (!"latest".equalsIgnoreCase(gav[2])) {
            return gav[2];
        }
        try {
            String hubDetectVersion;
            URL versionUrl = new URL(String.format(this.latestVersionUrl, this.artifactoryBase, gav[0], gav[1], this.artifactRepositoryName));
            try (InputStream stream = versionUrl.openStream();){
                hubDetectVersion = IOUtil.toString((InputStream)stream);
            }
            return hubDetectVersion;
        }
        catch (IOException e) {
            return OLD_HUB_DETECT.split(":")[2];
        }
    }

    private String handlePlaceholders(String rootPath, String value) {
        return value.replace("$rootProject", rootPath);
    }

    private void unzip(File zipFile, File destination, boolean noparent) {
        this.getLog().info((CharSequence)String.format("Extracting '%s' to '%s'", zipFile.getAbsolutePath(), destination.getAbsolutePath()));
        try {
            ZipEntry entry;
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
            while ((entry = in.getNextEntry()) != null) {
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                File file = new File(destination, path);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            in.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to unzip " + zipFile.getAbsolutePath(), e);
        }
    }
}

