/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.resourceloading;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.hibernate.validator.internal.util.CollectionHelper;

class AggregateResourceBundle
extends ResourceBundle {
    private final Map<String, Object> contents;

    AggregateResourceBundle(List<ResourceBundle> bundles) {
        if (bundles == null || bundles.isEmpty()) {
            this.contents = Collections.emptyMap();
            return;
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        for (ResourceBundle bundle : bundles) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                contents.putIfAbsent(key, bundle.getObject(key));
            }
        }
        this.contents = CollectionHelper.toImmutableMap(contents);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.contents.get(key);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.contents.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.parent == null) {
            return Collections.enumeration(this.contents.keySet());
        }
        HashSet<String> keySet = CollectionHelper.newHashSet(this.contents.keySet());
        keySet.addAll(Collections.list(this.parent.getKeys()));
        return Collections.enumeration(keySet);
    }
}

