/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.talend.maplang.el.interpreter.api.CustomOpFunction;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.ExprLangFunction;
import org.talend.maplang.el.parser.CustomOperators;

public class CustomOperatorsImpl
implements CustomOperators {
    private Map<String, CustomOpFunction> customOpFunctions;

    public CustomOperatorsImpl(ExprLangContext context) {
        this.loadCustomOpFunctions(context);
    }

    private void loadCustomOpFunctions(ExprLangContext context) {
        this.customOpFunctions = new HashMap<String, CustomOpFunction>();
        Map<String, ExprLangFunction> functions = context.getFunctions();
        for (Map.Entry<String, ExprLangFunction> entry : functions.entrySet()) {
            ExprLangFunction function = entry.getValue();
            if (!(function instanceof CustomOpFunction)) continue;
            CustomOpFunction customOpFunc = (CustomOpFunction)function;
            String key = customOpFunc.getOperator(0);
            this.customOpFunctions.put(key, customOpFunc);
        }
    }

    private boolean isOperatorOfKind(String operator, CustomOpFunction.Kind kind) {
        CustomOpFunction customOpFunc = this.customOpFunctions.get(operator.toLowerCase());
        return customOpFunc != null ? customOpFunc.getKind() == kind : false;
    }

    @Override
    public boolean isUnaryOperator(String operator) {
        return this.isOperatorOfKind(operator, CustomOpFunction.Kind.UNARY);
    }

    @Override
    public boolean isBinaryOperator(String operator) {
        return this.isOperatorOfKind(operator, CustomOpFunction.Kind.BINARY);
    }

    @Override
    public boolean isTernaryOperator(String operator) {
        return this.isOperatorOfKind(operator, CustomOpFunction.Kind.TERNARY);
    }

    @Override
    public String getCustomOpFunctionName(String operator) {
        CustomOpFunction customOpFunc = this.customOpFunctions.get(operator.toLowerCase());
        return customOpFunc != null ? customOpFunc.getName() : null;
    }

    @Override
    public int getNbrOfCustomOp(String operatorName, int position) {
        String operator;
        CustomOpFunction customOpFunc = this.customOpFunctions.get(operatorName.toLowerCase());
        if (customOpFunc != null && (operator = customOpFunc.getOperator(position)) != null) {
            String normalizedOp = operator;
            return normalizedOp.split(" ").length;
        }
        return 0;
    }

    @Override
    public String getOperator(String operatorName, int position) {
        CustomOpFunction customOpFunc = this.customOpFunctions.get(operatorName.toLowerCase());
        if (customOpFunc != null) {
            return customOpFunc.getOperator(position);
        }
        return null;
    }

    @Override
    public String[] getAllOperators() {
        ArrayList<String> operators = new ArrayList<String>(this.customOpFunctions.keySet());
        Collections.sort(operators);
        return operators.toArray(new String[operators.size()]);
    }
}

