/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.IntStream;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.api.ArithmeticOperationException;
import org.talend.maplang.el.interpreter.api.ExprEvalVisitor;
import org.talend.maplang.el.interpreter.api.ExprInterpreterException;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.FunctionCallException;
import org.talend.maplang.el.interpreter.api.InterpreterErrorMessageProvider;
import org.talend.maplang.el.interpreter.api.NotComparableException;
import org.talend.maplang.el.interpreter.api.NotEvaluableAsBooleanException;
import org.talend.maplang.el.interpreter.impl.DefaultInterpreterErrorMessageProvider;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctions;
import org.talend.maplang.el.interpreter.impl.function.JavaFunction;
import org.talend.maplang.el.parser.DSLException;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;
import org.talend.maplang.hpath.HPathStore;
import org.talend.maplang.hpath.HPathStoreException;

public class ExprEvalVisitorImpl
implements ExprEvalVisitor {
    private DslContent _dslContent;
    private final HPathStore _store;
    private final ExprLangFunctions _functions;
    private final ClassLoader _javaClassLoader;
    private final boolean _isJavaCallAllowed;
    private InterpreterErrorMessageProvider _errorMessageProvider;

    public ExprEvalVisitorImpl(ExprLangContext context) {
        this._store = context.getStore();
        this._functions = new ExprLangFunctions(context);
        this._javaClassLoader = context.getJavaClassLoader();
        this._isJavaCallAllowed = context.isJavaCallAllowed();
        this._errorMessageProvider = this.initDefaultErrorMessageProvider();
    }

    @Override
    public void setDslContent(DslContent dslContent) {
        this._dslContent = dslContent;
    }

    protected DslContent getDslContent() {
        return this._dslContent;
    }

    private InterpreterErrorMessageProvider initDefaultErrorMessageProvider() {
        return new DefaultInterpreterErrorMessageProvider();
    }

    @Override
    public void setErrorMessageProvider(InterpreterErrorMessageProvider errorMessageProvider) {
        this._errorMessageProvider = errorMessageProvider == null ? this.initDefaultErrorMessageProvider() : errorMessageProvider;
    }

    protected InterpreterErrorMessageProvider getErrorMessageProvider() {
        return this._errorMessageProvider;
    }

    protected HPathStore getStore() {
        return this._store;
    }

    protected ExprLangFunctions getFunctions() {
        return this._functions;
    }

    protected ClassLoader getJavaClassLoader() {
        return this._javaClassLoader;
    }

    protected boolean isJavaCallAllowed() {
        return this._isJavaCallAllowed;
    }

    @Override
    public ExprValue visitRoot(ELNode rootNode) {
        return this.visitChildren(rootNode);
    }

    @Override
    public ExprValue visitBlock(ELNode blockNode) {
        return this.visitChildren(blockNode);
    }

    @Override
    public ExprValue visitLiteral(ELNode literalNode) {
        ELNodeType type = literalNode.getType();
        String image = literalNode.getImage();
        try {
            switch (type) {
                case BOOLEAN_LITERAL: {
                    return this.newExprValue(image, Boolean.class);
                }
                case BYTES_LITERAL: {
                    return this.newExprValue(image, byte[].class);
                }
                case DOUBLE_LITERAL: {
                    return this.newExprValue(image, Double.class);
                }
                case FLOAT_LITERAL: {
                    return this.newExprValue(image, Float.class);
                }
                case LONG_LITERAL: {
                    return this.newExprValue(image, Long.class);
                }
                case INTEGER_LITERAL: {
                    return this.newExprValue(image, Integer.class);
                }
                case DECIMAL_LITERAL: {
                    return this.newExprValue(image, BigDecimal.class);
                }
                case STRING_LITERAL: {
                    return this.newExprValue(image, String.class);
                }
                case NULL_LITERAL: {
                    return this.newNullExprValue();
                }
            }
            return this.newNullExprValue();
        }
        catch (ExprValueException e) {
            throw new ExprInterpreterException(e.getMessage(), this._dslContent, literalNode.getBeginLocation());
        }
    }

    @Override
    public ExprValue visitArray(ELNode arrayNode) {
        throw new ExprInterpreterException(Messages.getMessage("ExprEvalVisitor.arrayNotSupported", new Object[0]));
    }

    @Override
    public ExprValue visitCompOp(ELNode compOpNode) {
        ExprValue value1 = this.evaluateFirstChildExpr(compOpNode);
        ExprValue value2 = this.evaluateSecondChildExpr(compOpNode);
        ExprValue result = null;
        try {
            switch (compOpNode.getType()) {
                case EQUAL: {
                    result = value1.equal(value2);
                    break;
                }
                case NOT_EQUAL: {
                    result = value1.notEqual(value2);
                    break;
                }
                case LOWER_THAN: {
                    result = value1.lowerThan(value2);
                    break;
                }
                case LOWER_OR_EQUAL: {
                    result = value1.lowerOrEqual(value2);
                    break;
                }
                case GREATER_THAN: {
                    result = value1.greaterThan(value2);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    result = value1.greaterOrEqual(value2);
                    break;
                }
                default: {
                    result = this.newNullExprValue();
                    break;
                }
            }
        }
        catch (ExprValueException e) {
            throw new NotComparableException(e.getMessage(), this._dslContent, compOpNode.getBeginLocation());
        }
        return result;
    }

    @Override
    public ExprValue visitAddOp(ELNode addOpNode) {
        ExprValue value1 = this.evaluateFirstChildExpr(addOpNode);
        ExprValue value2 = this.evaluateSecondChildExpr(addOpNode);
        ExprValue result = null;
        try {
            switch (addOpNode.getType()) {
                case PLUS: {
                    result = value1.add(value2);
                    break;
                }
                case MINUS: {
                    result = value1.subtract(value2);
                    break;
                }
                default: {
                    result = this.newNullExprValue();
                    break;
                }
            }
        }
        catch (ExprValueException e) {
            throw new ArithmeticOperationException(e.getMessage(), this._dslContent, addOpNode.getBeginLocation());
        }
        return result;
    }

    @Override
    public ExprValue visitMultOp(ELNode multOpNode) {
        ExprValue value1 = this.evaluateFirstChildExpr(multOpNode);
        ExprValue value2 = this.evaluateSecondChildExpr(multOpNode);
        ExprValue result = null;
        try {
            switch (multOpNode.getType()) {
                case MULTIPLY: {
                    result = value1.multiply(value2);
                    break;
                }
                case DIVIDE: {
                    result = value1.divide(value2);
                    break;
                }
                case MODULO: {
                    result = value1.modulo(value2);
                    break;
                }
                default: {
                    result = this.newNullExprValue();
                    break;
                }
            }
        }
        catch (ExprValueException e) {
            throw new ArithmeticOperationException(e.getMessage(), this._dslContent, multOpNode.getBeginLocation());
        }
        return result;
    }

    @Override
    public ExprValue visitLogicalOp(ELNode logicalOpNode) {
        switch (logicalOpNode.getType()) {
            case AND: {
                return this.visitAndExpr(logicalOpNode);
            }
            case OR: {
                return this.visitOrExpr(logicalOpNode);
            }
        }
        return this.newNullExprValue();
    }

    protected ExprValue visitAndExpr(ELNode logicalOpNode) {
        ExprValue result = null;
        Exception lastException = null;
        for (int i = 0; i < logicalOpNode.getNbrOfChildren(); ++i) {
            ExprValue value = null;
            try {
                value = this.evaluateChildExpr(logicalOpNode, i);
            }
            catch (Exception e) {
                lastException = e;
                value = null;
            }
            if (value != null) {
                try {
                    value.booleanValue();
                }
                catch (ExprValueException e) {
                    lastException = new NotEvaluableAsBooleanException(e.getMessage(), this._dslContent, logicalOpNode.getBeginLocation());
                    value = null;
                }
            }
            if (result == null) {
                result = value;
            } else if (value != null) {
                result = result.and(value);
            }
            if (result != null && !result.booleanValue().booleanValue()) break;
        }
        if ((result == null || result.booleanValue().booleanValue()) && lastException != null) {
            throw new NotEvaluableAsBooleanException(lastException.getMessage());
        }
        return this.newExprValue(result.booleanValue());
    }

    protected ExprValue visitOrExpr(ELNode logicalOpNode) {
        ExprValue result = null;
        Exception lastException = null;
        for (int i = 0; i < logicalOpNode.getNbrOfChildren(); ++i) {
            ExprValue value = null;
            try {
                value = this.evaluateChildExpr(logicalOpNode, i);
            }
            catch (Exception e) {
                lastException = e;
                value = null;
            }
            if (value != null) {
                try {
                    value.booleanValue();
                }
                catch (ExprValueException e) {
                    lastException = new NotEvaluableAsBooleanException(e.getMessage(), this._dslContent, logicalOpNode.getBeginLocation());
                    value = null;
                }
            }
            if (result == null) {
                result = value;
            } else if (value != null) {
                result = result.or(value);
            }
            if (result != null && result.booleanValue().booleanValue()) break;
        }
        if (!(result != null && result.booleanValue().booleanValue() || lastException == null)) {
            throw new NotEvaluableAsBooleanException(lastException.getMessage());
        }
        return this.newExprValue(result.booleanValue());
    }

    @Override
    public ExprValue visitNot(ELNode notNode) {
        ELNode eLNode = notNode.getChildren().get(0);
        ExprValue value = eLNode.accept(this);
        try {
            return value.not();
        }
        catch (ExprValueException e) {
            throw new NotEvaluableAsBooleanException(e.getMessage(), this._dslContent, notNode.getBeginLocation());
        }
    }

    @Override
    public ExprValue visitHPath(ELNode hPathNode) {
        return this.getStoredValue(hPathNode);
    }

    @Override
    public ExprValue visitVariable(ELNode variableNode) {
        return this.getStoredValue(variableNode);
    }

    protected ExprValue getStoredValue(ELNode node) {
        try {
            String variableName = node.getImage();
            Object value = this.getStoredValue(variableName);
            ExprValue result = this.newExprValue(value);
            return result;
        }
        catch (HPathStoreException e) {
            throw new ExprInterpreterException(e.getMessage(), this._dslContent, node.getBeginLocation());
        }
        catch (DSLException e) {
            if (node.hasBeginLocation()) {
                e.setLocationAndDslContent(node.getBeginLocation(), this._dslContent);
            }
            throw e;
        }
    }

    @Override
    public ExprValue visitFunctionCall(ELNode functionNode) {
        String functionName = functionNode.getImage();
        if (JavaFunction.isJavaFunction(functionName)) {
            return this.visitJavaFunction(functionNode);
        }
        if (this._functions.isDefinedFunction(functionName)) {
            if (this._functions.isExtendedFunction(functionName)) {
                try {
                    return this._functions.callExtended(functionName, this, functionNode);
                }
                catch (ExprLangFunctionException e) {
                    throw new FunctionCallException(e.getMessage(), this._dslContent, functionNode.getBeginLocation());
                }
            }
            ExprValue[] args = this.evaluateArguments(functionNode);
            try {
                return this._functions.call(functionName, args);
            }
            catch (ExprLangFunctionException e) {
                throw new FunctionCallException(e.getMessage(), this._dslContent, functionNode.getBeginLocation());
            }
        }
        throw new FunctionCallException(Messages.getMessage("ExprEvalVisitor.unknownBuiltinFunction", functionName), this._dslContent, functionNode.getBeginLocation());
    }

    protected ExprValue visitJavaFunction(ELNode javaFuncNode) {
        if (!this._isJavaCallAllowed) {
            throw new FunctionCallException(Messages.getMessage("ExprEvalVisitor.javaCallNotAllowed", javaFuncNode.toString()));
        }
        if (javaFuncNode.hasChildOfType(ELNodeType.FUNCTION_CALL)) {
            return this.javaCall(javaFuncNode);
        }
        return this.javaStaticCall(javaFuncNode);
    }

    protected ExprValue javaCall(ELNode javaFuncNode) {
        ELNode javaNew = javaFuncNode.getFirstChild(ELNodeType.FUNCTION_CALL);
        ExprValue[] javaNewArgs = this.evaluateArguments(javaNew);
        String className = javaNewArgs[0].stringValue();
        ExprValue[] constructorArgs = this.keepSomeValues(javaNewArgs, 1, -1);
        ExprValue[] args = this.evaluateArguments(javaFuncNode, 1, -1);
        String methodName = args[0].stringValue();
        ExprValue[] methodArgs = this.keepSomeValues(args, 1, -1);
        JavaFunction javaFunction = new JavaFunction(className, methodName, this._javaClassLoader);
        try {
            return javaFunction.call(constructorArgs, methodArgs);
        }
        catch (ExprLangFunctionException e) {
            throw new FunctionCallException(e.getMessage(), this._dslContent, javaFuncNode.getBeginLocation());
        }
    }

    protected ExprValue javaStaticCall(ELNode javaFuncNode) {
        ExprValue[] args = this.evaluateArguments(javaFuncNode);
        String className = args[0].stringValue();
        String methodName = args[1].stringValue();
        ExprValue[] methodArgs = this.keepSomeValues(args, 2, -1);
        JavaFunction javaFunction = new JavaFunction(className, methodName, this._javaClassLoader);
        try {
            return javaFunction.callStatic(methodArgs);
        }
        catch (ExprLangFunctionException e) {
            throw new FunctionCallException(e.getMessage(), this._dslContent, javaFuncNode.getBeginLocation());
        }
    }

    @Override
    public ExprValue visitAssignment(ELNode assignNode) {
        String target = assignNode.getFirstChild(ELNodeType.HPATH, ELNodeType.VARIABLE).getImage();
        ExprValue value = assignNode.getChildren().get(1).accept(this);
        this.storeValue(target, value.getValue());
        return value;
    }

    @Override
    public ExprValue visitIfThenElse(ELNode ifThenElseNode) {
        List<ELNode> conditionNodes = ifThenElseNode.getChildren(ELNodeType.CONDITION);
        List<ELNode> thenNodes = ifThenElseNode.getChildren(ELNodeType.THEN);
        int size = conditionNodes.size();
        if (size != thenNodes.size()) {
            throw new ExprInterpreterException(Messages.getMessage("ExprEvalVisitor.invalidIfThenElseStat", new Object[0]));
        }
        ELNode elseNode = ifThenElseNode.getFirstChild(ELNodeType.ELSE);
        for (int i = 0; i < size; ++i) {
            if (!conditionNodes.get(i).getChild(0).accept(this).booleanValue().booleanValue()) continue;
            return thenNodes.get(i).getChild(0).accept(this);
        }
        if (elseNode != null) {
            return elseNode.getChild(0).accept(this);
        }
        return this.newNullExprValue();
    }

    @Override
    public ExprValue visitSwitchCases(ELNode switchNode) {
        ELNode condNode = switchNode.getFirstChild(ELNodeType.CONDITION);
        ExprValue value = condNode.getChild(0).accept(this);
        List<ELNode> cases = switchNode.getChildren(ELNodeType.CASE);
        for (ELNode caseNode : cases) {
            ExprValue caseValue = caseNode.getChild(0).accept(this);
            if (!caseValue.equal(value).booleanValue().booleanValue()) continue;
            List<ELNode> expressions = caseNode.getChild(1).getChildren();
            ExprValue exprResult = null;
            for (int i = 0; i < expressions.size(); ++i) {
                exprResult = expressions.get(i).accept(this);
            }
            return exprResult;
        }
        ELNode defaultNode = switchNode.getFirstChild(ELNodeType.DEFAULT);
        if (defaultNode != null) {
            return defaultNode.getChild(0).accept(this);
        }
        return this.newNullExprValue();
    }

    protected ExprValue newExprValue(String value, Class<?> clazz) {
        return new ExprValue(value, clazz);
    }

    protected ExprValue newExprValue(Object value) {
        return new ExprValue(value);
    }

    protected ExprValue newNullExprValue() {
        return new ExprValue(null);
    }

    protected ExprValue visitChildren(ELNode eLNode) {
        ExprValue value = null;
        for (int i = 0; i < eLNode.getChildren().size(); ++i) {
            ELNode child = eLNode.getChildren().get(i);
            value = child.accept(this);
        }
        return value;
    }

    protected ExprValue[] evaluateArguments(ELNode funcNode) {
        int nbrOfArgs = funcNode.getChildren().size();
        ExprValue[] args = new ExprValue[nbrOfArgs];
        IntStream.range(0, nbrOfArgs).forEach(i -> {
            args[i] = funcNode.getChildren().get(i).accept(this);
        });
        return args;
    }

    protected ExprValue[] evaluateArguments(ELNode funcNode, int startIndex, int length) {
        int nbrOfChildren = funcNode.getChildren().size();
        int size = length == -1 ? nbrOfChildren - startIndex : length;
        ExprValue[] args = new ExprValue[size];
        IntStream.range(startIndex, startIndex + size).forEach(i -> {
            args[i - startIndex] = funcNode.getChildren().get(i).accept(this);
        });
        return args;
    }

    protected ExprValue evaluateFirstChildExpr(ELNode eLNode) {
        return this.evaluateChildExpr(eLNode, 0);
    }

    protected ExprValue evaluateSecondChildExpr(ELNode eLNode) {
        return this.evaluateChildExpr(eLNode, 1);
    }

    protected ExprValue evaluateChildExpr(ELNode eLNode, int index) {
        ELNode child = eLNode.getChild(index);
        return child.accept(this);
    }

    protected ExprValue[] keepSomeValues(ExprValue[] exprValues, int startIndex, int length) {
        int size = length == -1 ? exprValues.length - startIndex : length;
        ExprValue[] keptValues = new ExprValue[size];
        System.arraycopy(exprValues, startIndex, keptValues, 0, size);
        return keptValues;
    }

    protected Object getStoredValue(String key) {
        if (this._store != null) {
            return this._store.get(key);
        }
        return null;
    }

    protected void storeValue(String key, Object value) {
        if (this._store != null) {
            this._store.put(key, value);
        }
    }
}

