/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;

public enum ExprValueType {
    BIGDECIMAL(BigDecimal.class, "BigDecimal", "Decimal", "Dec"),
    BYTES(byte[].class, "Bytes"),
    DATETIME(OffsetDateTime.class, "DateTime"),
    DATE(LocalDate.class, "Date"),
    TIME(LocalTime.class, "Time"),
    INTEGER(Integer.class, "Integer", "Int"),
    LONG(Long.class, "Long"),
    FLOAT(Float.class, "Float"),
    DOUBLE(Double.class, "Double"),
    STRING(String.class, "String"),
    BOOLEAN(Boolean.class, "Boolean", "Bool"),
    NULL("Null");

    private Class<?> valueClass;
    private String[] labels;

    private ExprValueType(String ... labels) {
        this((Class<?>)null, labels);
    }

    private ExprValueType(Class<?> valueClass, String ... labels) {
        this.valueClass = valueClass;
        this.labels = labels;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public static ExprValueType getType(Class<?> valueClass) {
        if (valueClass == null) {
            return NULL;
        }
        for (ExprValueType valueType : ExprValueType.values()) {
            if (!valueClass.equals(valueType.getValueClass())) continue;
            return valueType;
        }
        return null;
    }

    public static ExprValueType getType(String label) {
        for (ExprValueType valueType : ExprValueType.values()) {
            boolean contains = Arrays.stream(valueType.labels).anyMatch(label::equalsIgnoreCase);
            if (!contains) continue;
            return valueType;
        }
        return null;
    }
}

