/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.api.ExprInterpreterException;

public class MathUtil {
    public static final float DEFAULT_FLOAT_RELATIVE_EPSILON = 1.0E-6f;
    public static final double DEFAULT_DOUBLE_RELATIVE_EPSILON = 1.0E-6;

    private static void checkFloatOperands(float x, float y) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isInfinite(x) || Float.isInfinite(y)) {
            throw new ExprInterpreterException(Messages.getMessage("MathUtil.invalidOperands", new Object[0]));
        }
    }

    private static void checkDoubleOperands(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y)) {
            throw new ExprInterpreterException(Messages.getMessage("MathUtil.invalidOperands", new Object[0]));
        }
    }

    public static boolean equals(float x, float y) {
        return MathUtil.equals(x, y, 1.0E-6f);
    }

    public static boolean equals(float x, float y, float relativeEpsilon) {
        MathUtil.checkFloatOperands(x, y);
        float absX = Math.abs(x);
        float absY = Math.abs(y);
        float largest = absX > absY ? absX : absY;
        float epsilon = Math.abs(relativeEpsilon);
        float diff = Math.abs(x - y);
        if (largest < 1.0f && diff < epsilon) {
            return true;
        }
        return diff < largest * epsilon;
    }

    public static boolean equals(double x, double y) {
        return MathUtil.equals(x, y, 1.0E-6);
    }

    public static boolean equals(double x, double y, double relativeEpsilon) {
        MathUtil.checkDoubleOperands(x, y);
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double largest = absX > absY ? absX : absY;
        double epsilon = Math.abs(relativeEpsilon);
        double diff = Math.abs(x - y);
        if (largest < 1.0 && diff < epsilon) {
            return true;
        }
        return diff < largest * epsilon;
    }
}

