/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class JavaClassUtils {
    static Map<Class<?>, Class<?>> UNBOXED = new HashMap();
    static Map<Class<?>, Class<?>> BOXED;

    static Constructor<?> getConstructor(Class<?> javaClass, Object[] parameterValues) throws NoSuchMethodException {
        return JavaClassUtils.getConstructor(javaClass, JavaClassUtils.getParameterTypes(parameterValues));
    }

    static Method getMethod(Class<?> javaClass, String methodName, Object[] parameterValues) throws NoSuchMethodException {
        return JavaClassUtils.getMethod(javaClass, methodName, JavaClassUtils.getParameterTypes(parameterValues));
    }

    static Class<?>[] getParameterTypes(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] classes = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            classes[i] = values[i] == null ? null : values[i].getClass();
        }
        return classes;
    }

    static Constructor<?> getConstructor(Class<?> javaClass, Class<?>[] parameterTypes) throws NoSuchMethodException {
        for (Constructor<?> ctor : javaClass.getConstructors()) {
            if (!JavaClassUtils.isAssignableFrom(ctor.getGenericParameterTypes(), ctor.isVarArgs(), parameterTypes)) continue;
            return ctor;
        }
        throw new NoSuchMethodException(javaClass.getName() + "#init" + Arrays.toString(parameterTypes));
    }

    static Method getMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        for (Method m : javaClass.getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || !JavaClassUtils.isAssignableFrom(m.getGenericParameterTypes(), m.isVarArgs(), parameterTypes)) continue;
            m.setAccessible(true);
            return m;
        }
        throw new NoSuchMethodException(javaClass.getName() + "#" + methodName + Arrays.toString(parameterTypes));
    }

    static boolean isAssignableFrom(Type[] methodParms, boolean isVarArgs, Class<?>[] parameterTypes) {
        if (methodParms.length == 0 && parameterTypes.length > 0) {
            return false;
        }
        for (int i = 0; i < methodParms.length; ++i) {
            if (i >= parameterTypes.length) {
                return isVarArgs;
            }
            if (i == methodParms.length - 1) {
                if (isVarArgs) {
                    Class<?> c1 = JavaClassUtils.getClass(methodParms[i]).getComponentType();
                    for (int j = i; j < parameterTypes.length; ++j) {
                        Class<?> c2 = parameterTypes[j];
                        if (c2.isArray()) {
                            c2 = c2.getComponentType();
                        }
                        if (JavaClassUtils.isAssignableFrom(c1, c2)) continue;
                        return false;
                    }
                    continue;
                }
                if (JavaClassUtils.isAssignableFrom(methodParms[i], parameterTypes[i])) {
                    return i == parameterTypes.length - 1;
                }
                return false;
            }
            if (JavaClassUtils.isAssignableFrom(methodParms[i], parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isAssignableFrom(Type t, Class<?> c2) {
        Class<?> c1 = JavaClassUtils.getClass(t);
        if (c1.isArray() && c2.isArray()) {
            return JavaClassUtils.isAssignableFrom(JavaClassUtils.getClass(c1.getComponentType()), c2.getComponentType());
        }
        return JavaClassUtils.isAssignableFrom(c1, c2);
    }

    static boolean isAssignableFrom(Class<?> c1, Class<?> c2) {
        return JavaClassUtils.box(c1).isAssignableFrom(JavaClassUtils.box(c2));
    }

    static Class<?> getClass(Type t) {
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            return Object[].class;
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        return Object.class;
    }

    static Object[] toVarArgs(Method method, Object[] parameterValues) {
        if (method.isVarArgs()) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            parameterValues = JavaClassUtils.getVarArgs(parameterValues, methodParameterTypes);
        }
        return parameterValues;
    }

    static Object[] getVarArgs(Object[] args, Class<?>[] methodParameterTypes) {
        if (args.length == methodParameterTypes.length && (args[args.length - 1] == null || args[args.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1]))) {
            return args;
        }
        Object[] newArgs = new Object[methodParameterTypes.length];
        System.arraycopy(args, 0, newArgs, 0, methodParameterTypes.length - 1);
        Class<?> varArgComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int varArgLength = args.length - methodParameterTypes.length + 1;
        Object varArgsArray = Array.newInstance(JavaClassUtils.box(varArgComponentType), varArgLength);
        System.arraycopy(args, methodParameterTypes.length - 1, varArgsArray, 0, varArgLength);
        if (varArgComponentType.isPrimitive()) {
            if (varArgsArray instanceof Short[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Short[])varArgsArray);
            } else if (varArgsArray instanceof Integer[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Integer[])varArgsArray);
            } else if (varArgsArray instanceof Long[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Long[])varArgsArray);
            } else if (varArgsArray instanceof Float[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Float[])varArgsArray);
            } else if (varArgsArray instanceof Double[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Double[])varArgsArray);
            } else if (varArgsArray instanceof Character[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Character[])varArgsArray);
            } else if (varArgsArray instanceof Byte[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Byte[])varArgsArray);
            } else if (varArgsArray instanceof Boolean[]) {
                varArgsArray = JavaClassUtils.toPrimitive((Boolean[])varArgsArray);
            }
        }
        newArgs[methodParameterTypes.length - 1] = varArgsArray;
        return newArgs;
    }

    public static Class<?> box(Class<?> c) {
        return c.isPrimitive() ? UNBOXED.get(c) : c;
    }

    public static Class<?> unbox(Class<?> c) {
        return BOXED.containsKey(c) ? BOXED.get(c) : c;
    }

    private static short[] toPrimitive(Short[] source) {
        short[] target = new short[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    private static int[] toPrimitive(Integer[] source) {
        int[] target = new int[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    private static long[] toPrimitive(Long[] source) {
        long[] target = new long[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    private static float[] toPrimitive(Float[] source) {
        float[] target = new float[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].floatValue();
        }
        return target;
    }

    private static double[] toPrimitive(Double[] source) {
        double[] target = new double[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    private static char[] toPrimitive(Character[] source) {
        char[] target = new char[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].charValue();
        }
        return target;
    }

    private static byte[] toPrimitive(Byte[] source) {
        byte[] target = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    private static boolean[] toPrimitive(Boolean[] source) {
        boolean[] target = new boolean[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    static {
        UNBOXED.put(Short.TYPE, Short.class);
        UNBOXED.put(Integer.TYPE, Integer.class);
        UNBOXED.put(Long.TYPE, Long.class);
        UNBOXED.put(Float.TYPE, Float.class);
        UNBOXED.put(Double.TYPE, Double.class);
        UNBOXED.put(Character.TYPE, Character.class);
        UNBOXED.put(Byte.TYPE, Byte.class);
        UNBOXED.put(Boolean.TYPE, Boolean.class);
        BOXED = new HashMap();
        BOXED.put(Short.class, Short.TYPE);
        BOXED.put(Integer.class, Integer.TYPE);
        BOXED.put(Long.class, Long.TYPE);
        BOXED.put(Float.class, Float.TYPE);
        BOXED.put(Double.class, Double.TYPE);
        BOXED.put(Character.class, Character.TYPE);
        BOXED.put(Byte.class, Byte.TYPE);
        BOXED.put(Boolean.class, Boolean.TYPE);
    }
}

