/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import org.talend.maplang.el.interpreter.api.CustomOpFunction;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Between
extends AbstractExprLangFunction
implements CustomOpFunction {
    public static final String NAME = "between";
    public static final String[] OPERATORS = new String[]{"between", "and"};

    public Between() {
        super(NAME, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public CustomOpFunction.Kind getKind() {
        return CustomOpFunction.Kind.TERNARY;
    }

    @Override
    public String getOperator(int position) {
        return OPERATORS[position];
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 3);
        Boolean result = null;
        try {
            result = Between.between(parms[0], parms[1], parms[2]);
        }
        catch (ExprValueException e) {
            throw new ExprLangFunctionException(e.getMessage());
        }
        return result;
    }

    public static boolean between(Object value, Object min, Object max) {
        ExprValue val = new ExprValue(value);
        ExprValue minVal = new ExprValue(min);
        ExprValue maxVal = new ExprValue(max);
        return val.greaterOrEqual(minVal).booleanValue() != false && val.lowerOrEqual(maxVal).booleanValue() != false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }
}

