/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.List;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.api.CustomOpFunction;
import org.talend.maplang.el.interpreter.api.ExprEvalVisitor;
import org.talend.maplang.el.interpreter.api.ExtendedExprLangFunction;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;

public class IsPresentIn
extends AbstractExprLangFunction
implements ExtendedExprLangFunction,
CustomOpFunction {
    public static final String NAME = "isPresentIn";
    public static final String[] OPERATORS = new String[]{"in"};

    public IsPresentIn() {
        super(NAME, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.unsupportedDirectCall", NAME));
    }

    @Override
    public void validateArguments(DslContent dslContent, ELNode ... argNodes) {
        this.checkNbrOfArguments(argNodes, 2);
        IsPresentIn.validateArgs(dslContent, argNodes);
    }

    public static void validateArgs(DslContent dslContent, ELNode ... argNodes) {
        ELNode argNode1 = argNodes[0];
        if (argNode1.getType() == ELNodeType.ARRAY) {
            throw new ExprLangFunctionException(Messages.getMessage("CustomOpFunction.invalidFirstOperandOfInOp", new Object[0]), dslContent, argNode1.getBeginLocation());
        }
        ELNode argNode2 = argNodes[1];
        if (argNode2.getType() != ELNodeType.ARRAY) {
            throw new ExprLangFunctionException(Messages.getMessage("CustomOpFunction.invalidSecondOperandOfInOp", new Object[0]), dslContent, argNode2.getBeginLocation());
        }
    }

    @Override
    public Object call(ExprEvalVisitor evalVisitor, ELNode ... argNodes) {
        return IsPresentIn.eval(evalVisitor, argNodes);
    }

    public static boolean eval(ExprEvalVisitor evalVisitor, ELNode ... argNodes) {
        ExprValue value = argNodes[0].accept(evalVisitor);
        List<ELNode> itemNodes = argNodes[1].getChildren();
        boolean result = false;
        for (ELNode itemNode : itemNodes) {
            ExprValue itemValue = itemNode.accept(evalVisitor);
            try {
                result = value.equal(itemValue).booleanValue();
            }
            catch (ExprValueException e) {
                result = false;
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    @Override
    public CustomOpFunction.Kind getKind() {
        return CustomOpFunction.Kind.BINARY;
    }

    @Override
    public String getOperator(int position) {
        return OPERATORS[position];
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

