/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.Arrays;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Left
extends AbstractExprLangFunction {
    public static final String NAME = "left";

    public Left() {
        super(NAME, RESULT_STRING_OR_BYTES_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        int length;
        this.checkNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, String.class, Number.class, byte[].class);
        this.checkArgumentClass(parms, 1, String.class, Number.class, byte[].class);
        try {
            length = this.exprValue(parms[1]).intValue();
        }
        catch (ExprValueException e) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.functionCallError", this.getName(), e.getMessage()));
        }
        this.checkInvalidNegativeIntArgumentByIndex(length, 1);
        if (parms[0] instanceof byte[]) {
            byte[] bytes = (byte[])parms[0];
            if (length > bytes.length) {
                byte[] result = new byte[length];
                System.arraycopy(bytes, 0, result, 0, bytes.length);
                return result;
            }
            if (length == bytes.length) {
                return bytes;
            }
            return Arrays.copyOfRange(bytes, 0, length);
        }
        String input = this.stringValue(parms[0]);
        if (length > input.length()) {
            int extraLength = length - input.length();
            StringBuilder buf = new StringBuilder();
            buf.append(input);
            for (int i = 0; i < extraLength; ++i) {
                buf.append(" ");
            }
            return buf.toString();
        }
        if (length == input.length()) {
            return input;
        }
        return input.substring(0, length);
    }
}

