/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Matches
extends AbstractExprLangFunction {
    private static int INPUT_INDEX = 0;
    private static int REGEX_INDEX = 1;
    private static int CASE_INSENSITIVE_INDEX = 2;
    private static int DOTALL_INDEX = 3;
    private static int TIMEOUT_INDEX = 4;
    public static final boolean CASE_INSENSITIVE = true;
    public static final boolean DOTALL = true;
    public static final String NAME = "matches";

    public Matches() {
        super(NAME, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2, 5);
        CharSequence input = this.getInput(INPUT_INDEX, TIMEOUT_INDEX, parms);
        this.checkArgumentClass(parms, REGEX_INDEX, (Class<?>)String.class);
        String regex = parms[REGEX_INDEX].toString();
        int flags = 0;
        if (parms.length > CASE_INSENSITIVE_INDEX) {
            this.checkArgumentClass(parms, CASE_INSENSITIVE_INDEX, Boolean.class, String.class, Number.class, byte[].class);
            if (this.booleanValue(parms[CASE_INSENSITIVE_INDEX])) {
                flags |= 2;
            }
        }
        if (parms.length > DOTALL_INDEX) {
            this.checkArgumentClass(parms, DOTALL_INDEX, Boolean.class, String.class, Number.class, byte[].class);
            if (this.booleanValue(parms[DOTALL_INDEX])) {
                flags |= 0x20;
            }
        }
        Pattern pattern = Pattern.compile(regex, flags);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }
}

