/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.regex.Pattern;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Replace
extends AbstractExprLangFunction {
    public static final String NAME = "replace";
    private static int INPUT_INDEX = 0;
    private static int REGEX_INDEX = 1;
    private static int REPLACEMENT_INDEX = 2;
    private static int ONLY_FIRST_OCCUR_INDEX = 3;
    private static int TIMEOUT_INDEX = 4;

    public Replace() {
        super(NAME, RESULT_STRING_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 3, 5);
        CharSequence input = this.getInput(INPUT_INDEX, TIMEOUT_INDEX, parms);
        this.checkArgumentClass(parms, REGEX_INDEX, (Class<?>)String.class);
        String pattern = parms[REGEX_INDEX].toString();
        this.checkArgumentNotNullByIndex(parms, REPLACEMENT_INDEX);
        String replacementString = this.stringValue(parms[REPLACEMENT_INDEX]);
        boolean onlyFirstOccur = false;
        if (parms.length >= 4) {
            this.checkArgumentClass(parms, ONLY_FIRST_OCCUR_INDEX, Boolean.class, String.class, Number.class, byte[].class);
            onlyFirstOccur = this.booleanValue(parms[ONLY_FIRST_OCCUR_INDEX]);
        }
        if (onlyFirstOccur) {
            return Pattern.compile(pattern).matcher(input).replaceFirst(replacementString);
        }
        return Pattern.compile(pattern).matcher(input).replaceAll(replacementString);
    }
}

