/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.Arrays;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class SubString
extends AbstractExprLangFunction {
    public static final String NAME = "substring";

    public SubString() {
        super(NAME, RESULT_STRING_OR_BYTES_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        int length;
        int beginIndex;
        this.checkNbrOfArguments(parms, 3);
        this.checkArgumentNotNullByIndex(parms, 0);
        this.checkArgumentClass(parms, 1, String.class, Number.class, byte[].class);
        this.checkArgumentClass(parms, 2, String.class, Number.class, byte[].class);
        try {
            beginIndex = this.exprValue(parms[1]).intValue();
            length = this.exprValue(parms[2]).intValue();
        }
        catch (ExprValueException e) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.functionCallError", this.getName(), e.getMessage()));
        }
        this.checkInvalidNegativeIntArgumentByIndex(beginIndex, 1);
        this.checkInvalidNegativeIntArgumentByIndex(length, 2);
        int endIndex = beginIndex + length;
        if (parms[0] instanceof byte[]) {
            byte[] bytes = (byte[])parms[0];
            if (beginIndex > bytes.length - 1) {
                throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.argumentOutOfBounds", 2, beginIndex, 0, bytes.length - 1));
            }
            if (endIndex > bytes.length) {
                throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.argumentOutOfBounds", 3, length, 0, bytes.length - beginIndex));
            }
            return Arrays.copyOfRange(bytes, beginIndex, endIndex);
        }
        String str = this.stringValue(parms[0]);
        if (beginIndex > str.length() - 1) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.argumentOutOfBounds", 2, beginIndex, 0, str.length() - 1));
        }
        if (endIndex > str.length()) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.argumentOutOfBounds", 3, length, 0, str.length() - beginIndex));
        }
        return str.substring(beginIndex, endIndex);
    }
}

