/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.talend.maplang.el.parser.ExprLangConstants;
import org.talend.maplang.el.parser.ExprLangParser;
import org.talend.maplang.el.parser.Token;

public class ParseException
extends Exception
implements ExprLangConstants {
    private Token token;
    private EnumSet<ExprLangConstants.TokenType> expectedTypes;
    private List<ExprLangParser.NonTerminalCall> callStack;
    private boolean alreadyAdjusted;

    public Token getLastToken() {
        return this.token;
    }

    public EnumSet<ExprLangConstants.TokenType> getExpectedTokens() {
        return this.expectedTypes;
    }

    public ParseException() {
    }

    public ParseException(Token token, EnumSet<ExprLangConstants.TokenType> expectedTypes, List<ExprLangParser.NonTerminalCall> callStack) {
        this.token = token;
        this.expectedTypes = expectedTypes;
        this.callStack = new ArrayList<ExprLangParser.NonTerminalCall>(callStack);
    }

    public ParseException(ExprLangParser parser, String message) {
        super(message);
        this.token = parser.lastConsumedToken;
        if (this.token != null && this.token.getNext() != null) {
            this.token = this.token.getNext();
        }
        this.callStack = new ArrayList<ExprLangParser.NonTerminalCall>(parser.parsingStack);
    }

    public ParseException(ExprLangParser parser, EnumSet<ExprLangConstants.TokenType> expectedTypes, List<ExprLangParser.NonTerminalCall> callStack) {
        this.token = parser.lastConsumedToken;
        if (this.token.getNext() != null) {
            this.token = this.token.getNext();
        }
        this.expectedTypes = expectedTypes;
    }

    public ParseException(String message) {
        super(message);
    }

    public ParseException(Token token) {
        this.token = token;
    }

    @Override
    public String getMessage() {
        String content;
        String msg = super.getMessage();
        if (this.token == null && this.expectedTypes == null) {
            return msg;
        }
        StringBuilder buf = new StringBuilder();
        if (msg != null) {
            buf.append(msg);
        }
        buf.append("\nEncountered an error at (or somewhere around) " + this.token.getLocation());
        if (this.expectedTypes != null && this.token != null && this.expectedTypes.contains((Object)this.token.getType())) {
            return buf.toString();
        }
        if (this.expectedTypes != null) {
            buf.append("\nWas expecting one of the following:\n");
            boolean isFirst = true;
            for (ExprLangConstants.TokenType type : this.expectedTypes) {
                if (!isFirst) {
                    buf.append(", ");
                }
                isFirst = false;
                buf.append((Object)type);
            }
        }
        if ((content = this.token.getImage()).length() > 32) {
            content = content.substring(0, 32) + "...";
        }
        buf.append("\nFound string \"" + ParseException.addEscapes(content) + "\" of type " + (Object)((Object)this.token.getType()));
        return buf.toString();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        this.adjustStackTrace();
        return super.getStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.adjustStackTrace();
        super.printStackTrace(s);
    }

    public Token getToken() {
        return this.token;
    }

    public static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int ch : str.codePoints().toArray()) {
            switch (ch) {
                case 8: {
                    retval.append("\\b");
                    continue block10;
                }
                case 9: {
                    retval.append("\\t");
                    continue block10;
                }
                case 10: {
                    retval.append("\\n");
                    continue block10;
                }
                case 12: {
                    retval.append("\\f");
                    continue block10;
                }
                case 13: {
                    retval.append("\\r");
                    continue block10;
                }
                case 34: {
                    retval.append("\\\"");
                    continue block10;
                }
                case 39: {
                    retval.append("\\'");
                    continue block10;
                }
                case 92: {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.appendCodePoint(ch);
                    continue block10;
                }
            }
        }
        return retval.toString();
    }

    private void adjustStackTrace() {
        StackTraceElement[] jvmCallStack;
        if (this.alreadyAdjusted || this.callStack == null || this.callStack.isEmpty()) {
            return;
        }
        LinkedList<StackTraceElement> fullTrace = new LinkedList<StackTraceElement>();
        LinkedList<StackTraceElement> ourCallStack = new LinkedList<StackTraceElement>();
        for (ExprLangParser.NonTerminalCall nonTerminalCall : this.callStack) {
            ourCallStack.add(nonTerminalCall.createStackTraceElement());
        }
        for (StackTraceElement regularEntry : jvmCallStack = super.getStackTrace()) {
            if (ourCallStack.isEmpty()) break;
            String methodName = regularEntry.getMethodName();
            StackTraceElement ourEntry = this.lastElementWithName(ourCallStack, methodName);
            if (ourEntry != null) {
                fullTrace.add(ourEntry);
            }
            fullTrace.add(regularEntry);
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[fullTrace.size()];
        this.setStackTrace(fullTrace.toArray(stackTraceElementArray));
        this.alreadyAdjusted = true;
    }

    private StackTraceElement lastElementWithName(List<StackTraceElement> elements, String methodName) {
        ListIterator<StackTraceElement> it = elements.listIterator(elements.size());
        while (it.hasPrevious()) {
            StackTraceElement elem = it.previous();
            if (!elem.getMethodName().equals(methodName)) continue;
            it.remove();
            return elem;
        }
        return null;
    }
}

