/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.talend.maplang.el.parser.CustomOperators;
import org.talend.maplang.el.parser.DSLFunctions;
import org.talend.maplang.el.parser.Messages;
import org.talend.maplang.el.parser.internal.ParsingContextException;

public class ParsingContext {
    public static final String KEYWORD = "keyword";
    public static final String OPERATOR = "Operator";
    private Set<ExpectedItem> expectedItems = new HashSet<ExpectedItem>();
    private DSLFunctions dslFunctions;
    private CustomOperators customOperators;

    public void setDslFunctions(DSLFunctions dslFunctions) {
        this.dslFunctions = dslFunctions;
    }

    public boolean isDefinedFunction(String functionName) {
        return this.dslFunctions != null ? this.dslFunctions.isDefinedFunction(functionName) : true;
    }

    public boolean isVisibleFunction(String functionName) {
        return this.dslFunctions != null ? this.dslFunctions.isVisibleFunction(functionName) : true;
    }

    public void setCustomOperators(CustomOperators customOperators) {
        this.customOperators = customOperators;
    }

    public boolean isUnaryOperator(String operatorName) {
        return this.customOperators != null ? this.customOperators.isUnaryOperator(operatorName) : false;
    }

    public boolean isBinaryOperator(String operatorName) {
        return this.customOperators != null ? this.customOperators.isBinaryOperator(operatorName) : false;
    }

    public boolean isTernaryOperator(String operatorName) {
        return this.customOperators != null ? this.customOperators.isTernaryOperator(operatorName) : false;
    }

    public String getCustomOpFunctionName(String operatorName) {
        return this.customOperators != null ? this.customOperators.getCustomOpFunctionName(operatorName) : null;
    }

    public int getNbrOfCustomOp(String operatorName, int position) {
        return this.customOperators != null ? this.customOperators.getNbrOfCustomOp(operatorName, position) : 0;
    }

    public String getCustomOperator(String operatorName, int position) {
        if (this.customOperators != null) {
            return this.customOperators.getOperator(operatorName, position);
        }
        return null;
    }

    public String[] getCustomOperators(String operatorName, int position) {
        String operator;
        if (this.customOperators != null && (operator = this.customOperators.getOperator(operatorName, position)) != null) {
            return operator.split(" ");
        }
        return new String[0];
    }

    public String[] getAllOperators() {
        if (this.customOperators != null) {
            return this.customOperators.getAllOperators();
        }
        return new String[0];
    }

    public void expectingOperators() throws ParsingContextException {
        String[] allOperators;
        this.clearExpectedItems(true);
        for (String operator : allOperators = this.getAllOperators()) {
            this.expectedItems.add(new ExpectedItem(OPERATOR, operator, true));
        }
    }

    public void expectingOperator(boolean optional, String operator) throws ParsingContextException {
        this.clearExpectedItems(true);
        this.expectedItems.add(new ExpectedItem(OPERATOR, operator, optional));
    }

    public void expectingKeyword(boolean optional, String ... expectedKeywords) throws ParsingContextException {
        this.clearExpectedItems(true);
        for (String expectedKeyword : expectedKeywords) {
            this.expectedItems.add(new ExpectedItem(KEYWORD, expectedKeyword, optional));
        }
    }

    protected void checkExpectedKeyword(String keyword) {
        if (!this.isExpectedKeyword(keyword)) {
            throw new ParsingContextException(Messages.getMessage("ParsingContext.unexpectedKeyword", keyword));
        }
    }

    public void consumeKeyword(String keyword) throws ParsingContextException {
        this.checkExpectedKeyword(keyword);
        this.clearExpectedItems(false);
    }

    public void consumeCompositeKeyword(String ... keywords) throws ParsingContextException {
        for (String keyword : keywords) {
            this.checkExpectedKeyword(keyword);
        }
        this.clearExpectedItems(false);
    }

    public void consumeOperator() throws ParsingContextException {
        if (!this.isExpectingOperator()) {
            throw new ParsingContextException(Messages.getMessage("ParsingContext.unexpectedCustomOp", new Object[0]));
        }
        this.clearExpectedItems(false);
    }

    protected void clearExpectedItems(boolean check) throws ParsingContextException {
        if (!this.expectedItems.isEmpty() && check) {
            for (ExpectedItem expectedItem : this.expectedItems) {
                if (expectedItem.isOptional()) continue;
                throw new ParsingContextException(Messages.getMessage("ParsingContext.missingExpectedItem", expectedItem.getImage()));
            }
        }
        this.expectedItems.clear();
    }

    public boolean isExpectingKeyword() {
        for (ExpectedItem expectedItem : this.expectedItems) {
            if (!this.isKeyword(expectedItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isExpectingOperator() {
        for (ExpectedItem expectedItem : this.expectedItems) {
            if (!this.isOperator(expectedItem)) continue;
            return true;
        }
        return false;
    }

    public List<String> getExpectedKeywords() {
        ArrayList<String> result = new ArrayList<String>();
        for (ExpectedItem expectedItem : this.expectedItems) {
            if (!this.isKeyword(expectedItem)) continue;
            result.add(expectedItem.getImage());
        }
        return result;
    }

    public String getExpectedOperator() {
        for (ExpectedItem expectedItem : this.expectedItems) {
            if (!this.isOperator(expectedItem)) continue;
            return expectedItem.getImage();
        }
        return null;
    }

    public void clearExpectedItems() throws ParsingContextException {
        this.clearExpectedItems(true);
    }

    protected boolean isExpectedKeyword(String keyword) {
        for (ExpectedItem expectedItem : this.expectedItems) {
            if (!this.isKeyword(expectedItem) || !keyword.toLowerCase().equals(expectedItem.getImage().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected boolean isKeyword(ExpectedItem item) {
        return this.isItemOfType(item, KEYWORD);
    }

    protected boolean isOperator(ExpectedItem item) {
        return this.isItemOfType(item, OPERATOR);
    }

    protected boolean isItemOfType(ExpectedItem item, String type) {
        return type.equals(item.getType());
    }

    public static class ExpectedItem {
        private String type;
        private String image;
        private boolean optional;

        public ExpectedItem(String type, String image, boolean optional) {
            this.type = type;
            this.image = image;
            this.optional = optional;
        }

        public String getType() {
            return this.type;
        }

        public String getImage() {
            return this.image;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

