/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.common.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.impl.CustomOperatorsImpl;
import org.talend.maplang.el.interpreter.impl.ExprInterpreterImpl;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctions;
import org.talend.maplang.el.parser.ExprParser;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;
import org.talend.trr.runtime.function.OverriddenFunctionClassLoader;

public final class VariableHelper {
    private static final int NO_INDEX = -1;

    private VariableHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<String> extractVariableNamesFromMaplang(String maplangExpression) {
        return VariableHelper.extractVariablesFromMaplang(maplangExpression);
    }

    public static Set<String> extractVariableNamesFromMaplang(ELNode node) {
        return VariableHelper.extractVariablesFromMaplang(node, -1, new LinkedHashSet<String>(), (n, i) -> n.getImage());
    }

    public static Set<String> extractVariablesFromMaplang(String maplangExpression) {
        return VariableHelper.extractVariablesFromMaplang(maplangExpression, (n, i) -> n.getImage());
    }

    public static <T> Set<T> extractVariablesFromMaplang(String maplangExpression, BiFunction<ELNode, Integer, T> varCreator) {
        ExprParser parser = VariableHelper.initializeParser();
        ELNode node = parser.parse(maplangExpression);
        return VariableHelper.extractVariablesFromMaplang(node, -1, new LinkedHashSet<String>(), varCreator);
    }

    public static ExprParser initializeParser() {
        ExprParser exprParser = new ExprParser();
        ExprLangContext exprLangContext = new ExprLangContext();
        exprLangContext.setExtensionsClassLoader(new OverriddenFunctionClassLoader());
        ExprInterpreterImpl.initContext(exprLangContext);
        exprParser.setDslFunctions(new ExprLangFunctions(exprLangContext));
        exprParser.setCustomOperators(new CustomOperatorsImpl(exprLangContext));
        return exprParser;
    }

    private static <T> Set<T> extractVariablesFromMaplang(ELNode node, int idx, Set<String> internalVars, BiFunction<ELNode, Integer, T> varCreator) {
        LinkedHashSet vars = new LinkedHashSet();
        if (node.getType() == ELNodeType.ASSIGN) {
            IntStream.range(1, node.getNbrOfChildren()).forEach(childIdx -> vars.addAll(VariableHelper.extractVariablesFromMaplang(node.getChild(childIdx), childIdx, internalVars, varCreator)));
            internalVars.add(node.getChild(0).getImage());
        } else if (node.getType() == ELNodeType.VARIABLE || node.getType() == ELNodeType.HPATH) {
            String varName = node.getImage();
            if (!internalVars.contains(varName)) {
                vars.add(varCreator.apply(node, idx));
            }
        } else if (node.getType() == ELNodeType.IF_THEN_ELSE || node.getType() == ELNodeType.SWITCH) {
            ArrayList internalVarsByChild = new ArrayList();
            IntStream.range(0, node.getNbrOfChildren()).forEach(childIdx -> {
                ELNode childNode = node.getChild(childIdx);
                if (childNode.getType() == ELNodeType.CONDITION) {
                    vars.addAll(VariableHelper.extractVariablesFromMaplang(childNode, childIdx, internalVars, varCreator));
                } else {
                    LinkedHashSet<String> branchAssignedVars = new LinkedHashSet<String>(internalVars);
                    vars.addAll(VariableHelper.extractVariablesFromMaplang(childNode, childIdx, branchAssignedVars, varCreator));
                    branchAssignedVars.removeAll(internalVars);
                    internalVarsByChild.add(branchAssignedVars);
                }
            });
            if (!(internalVarsByChild.isEmpty() || node.getFirstChild(ELNodeType.ELSE) == null && node.getFirstChild(ELNodeType.DEFAULT) == null)) {
                Set nodeInternalVars = (Set)internalVarsByChild.remove(0);
                internalVarsByChild.forEach(nodeInternalVars::retainAll);
                internalVars.addAll(nodeInternalVars);
            }
        } else {
            IntStream.range(0, node.getNbrOfChildren()).forEach(childIdx -> vars.addAll(VariableHelper.extractVariablesFromMaplang(node.getChild(childIdx), childIdx, internalVars, varCreator)));
        }
        return vars;
    }
}

