/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.presigned.runtime.service;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.talend.dgp.common.tenantcontext.TenantContextSingle;
import org.talend.trr.presigned.runtime.service.RestTemplateRuleProvider;
import org.talend.tsd.dictionary.provider.config.DictionaryProviderProperties;
import org.talend.tsd.dictionary.provider.config.RestTemplateDictionaryProviderConfig;
import org.talend.tsd.dictionary.provider.service.RestTemplateDictionaryProvider;
import org.talend.tsd.maven.connector.resttemplate.config.RestTemplateConnectorProperties;
import org.talend.tsd.maven.connector.resttemplate.service.RestTemplateArtifactService;

public class RestTemplateRuleProviderConfig {
    private final RestTemplateDictionaryProviderConfig dictionaryProviderConfig = new RestTemplateDictionaryProviderConfig();
    private final RestTemplateArtifactService artifactService;
    private final Path temporaryFolder;

    public RestTemplateRuleProviderConfig(RestTemplateConnectorProperties connectorProp) {
        this.artifactService = this.dictionaryProviderConfig.artifactService(connectorProp);
        this.temporaryFolder = Paths.get(connectorProp.getTemporaryFolder(), new String[0]);
    }

    public RestTemplateRuleProvider preSignedRuleProvider(String tenantId) {
        TenantContextSingle tenantContext = new TenantContextSingle(tenantId);
        return new RestTemplateRuleProvider(tenantContext, this.artifactService, this.temporaryFolder);
    }

    public RestTemplateDictionaryProvider dictionaryProvider(DictionaryProviderProperties providerProp) {
        return this.dictionaryProviderConfig.build(this.artifactService, providerProp);
    }
}

