/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.converter.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.talend.trr.runtime.converter.Converter;
import org.talend.trr.runtime.converter.UnableToConvertException;

public abstract class StringToDateTimeConverter<T>
implements Converter<String, T> {
    private List<DateTimeFormatter> formatters;

    public Converter<String, T> withFormats(List<String> formats) {
        this.formatters = !formats.isEmpty() ? formats.stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList()) : Collections.singletonList(this.getDefaultFormatter());
        return this;
    }

    @Override
    public T convert(String value) throws UnableToConvertException {
        if (StringUtils.isNotEmpty(value)) {
            return (T)this.formatters.stream().map(formatter -> {
                try {
                    return this.parse(value, (DateTimeFormatter)formatter);
                }
                catch (DateTimeParseException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElseThrow(UnableToConvertException::new);
        }
        throw new UnableToConvertException("empty value");
    }

    protected abstract T parse(String var1, DateTimeFormatter var2);

    protected abstract DateTimeFormatter getDefaultFormatter();

    public static class StringToDateTime
    extends StringToDateTimeConverter<OffsetDateTime> {
        @Override
        protected OffsetDateTime parse(String value, DateTimeFormatter formatter) {
            try {
                return OffsetDateTime.parse(value, formatter);
            }
            catch (DateTimeParseException e) {
                LocalDateTime localDateTime = LocalDateTime.parse(value, formatter);
                return OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
            }
        }

        @Override
        protected DateTimeFormatter getDefaultFormatter() {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        }
    }

    public static class StringToTime
    extends StringToDateTimeConverter<LocalTime> {
        @Override
        protected LocalTime parse(String value, DateTimeFormatter formatter) {
            return LocalTime.parse(value, formatter);
        }

        @Override
        protected DateTimeFormatter getDefaultFormatter() {
            return DateTimeFormatter.ISO_LOCAL_TIME;
        }
    }

    public static class StringToDate
    extends StringToDateTimeConverter<LocalDate> {
        @Override
        protected LocalDate parse(String value, DateTimeFormatter formatter) {
            return LocalDate.parse(value, formatter);
        }

        @Override
        protected DateTimeFormatter getDefaultFormatter() {
            return DateTimeFormatter.ISO_LOCAL_DATE;
        }
    }
}

