/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.function;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.ExprLangFunction;
import org.talend.trr.runtime.function.FunctionException;

public class IsBetween
implements ExprLangFunction {
    @Override
    public String getName() {
        return "isBetween";
    }

    @Override
    public Object call(ExprLangContext exprLangContext, Object ... objects) {
        if (objects.length != 3) {
            throw new FunctionException(String.format("Wrong number of parameters (expected: 3, found: %d)", objects.length));
        }
        List<Object> params = Arrays.asList(objects);
        if (params.stream().allMatch(obj -> obj instanceof Number)) {
            return this.isNumberBetween(params.stream().map(p -> (Number)p).collect(Collectors.toList()));
        }
        if (params.stream().allMatch(obj -> obj instanceof LocalDate)) {
            return this.isDateBetween(params.stream().map(p -> (LocalDate)p).collect(Collectors.toList()));
        }
        if (params.stream().allMatch(obj -> NumberUtils.isCreatable(obj.toString()))) {
            return this.isNumberBetween(params.stream().map(p -> NumberUtils.createNumber(p.toString())).collect(Collectors.toList()));
        }
        try {
            List<LocalDate> dates = params.stream().map(d -> LocalDate.parse(d.toString())).collect(Collectors.toList());
            return this.isDateBetween(dates);
        }
        catch (DateTimeParseException e) {
            throw new FunctionException("Unable to compare the parameters", e);
        }
    }

    private boolean isDateBetween(List<LocalDate> dates) {
        LocalDate toCompare = dates.get(0);
        if (dates.get(2).isBefore(dates.get(1))) {
            Collections.swap(dates, 1, 2);
        }
        LocalDate min = dates.get(1);
        LocalDate max = dates.get(2);
        return toCompare.isAfter(min) && toCompare.isBefore(max);
    }

    private boolean isNumberBetween(List<Number> numbers) {
        List decNumbers = numbers.stream().map(n -> new BigDecimal(n.toString())).collect(Collectors.toList());
        if (((BigDecimal)decNumbers.get(1)).compareTo((BigDecimal)decNumbers.get(2)) > 0) {
            Collections.swap(decNumbers, 1, 2);
        }
        BigDecimal toCompare = (BigDecimal)decNumbers.get(0);
        BigDecimal min = (BigDecimal)decNumbers.get(1);
        BigDecimal max = (BigDecimal)decNumbers.get(2);
        return toCompare.compareTo(min) > -1 && toCompare.compareTo(max) < 1;
    }
}

