/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.statistics.SemanticQualityAnalyzer;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.ExprLangFunction;
import org.talend.maplang.hpath.HPathStore;
import org.talend.trr.runtime.exception.DQCategoryNotFoundException;
import org.talend.trr.runtime.function.FunctionException;
import org.talend.trr.runtime.model.NativeType;

public class IsOfType
implements ExprLangFunction {
    @Override
    public String getName() {
        return "isOfType";
    }

    @Override
    public Object call(ExprLangContext exprLangContext, Object ... params) {
        Boolean isSemanticTypeNameAColumn;
        if (params.length != 2) {
            throw new FunctionException(String.format("Wrong number of parameters (expected: 2, found: %d)", params.length));
        }
        Object value = params[0];
        if (value == null) {
            return false;
        }
        String typeName = params[1].toString();
        HPathStore store = exprLangContext.getStore();
        if (store.get(typeName) != null) {
            typeName = store.get(typeName).toString();
        }
        if ((isSemanticTypeNameAColumn = (Boolean)store.get("semanticTypeNameAsColumn")) != null && isSemanticTypeNameAColumn.booleanValue()) {
            typeName = this.getDataTypeNameFromLabel(store, typeName);
        }
        try {
            NativeType nativeType = NativeType.valueOf(typeName.toUpperCase());
            return this.isNativeType(nativeType, value);
        }
        catch (IllegalArgumentException e) {
            return this.isSemanticType(exprLangContext, typeName, value.toString(), isSemanticTypeNameAColumn);
        }
    }

    private String getDataTypeNameFromLabel(HPathStore store, String typeLabel) {
        DictionarySnapshot dictionarySnapshot = (DictionarySnapshot)store.get("dictionarySnapshot");
        Optional<DQCategory> category = dictionarySnapshot.getMetadata().values().stream().filter(cat -> cat.getLabel().equals(typeLabel)).findFirst();
        if (category.isPresent()) {
            return category.get().getName();
        }
        return typeLabel;
    }

    private boolean isNativeType(NativeType nativeType, Object value) {
        Set<String> possibleTypes = nativeType.getEquivalentJavaTypes();
        String dataType = value.getClass().getSimpleName().toUpperCase();
        if ("STRING".equals(dataType)) {
            dataType = TypeInferenceUtils.getDataType((String)((String)value)).name();
        }
        return possibleTypes.contains(dataType);
    }

    private Object isSemanticType(ExprLangContext exprLangContext, String semanticTypeName, String value, Boolean isSemanticTypeNameAColumn) {
        HPathStore store = exprLangContext.getStore();
        DictionarySnapshot dictionarySnapshot = (DictionarySnapshot)store.get("dictionarySnapshot");
        DQCategory category = dictionarySnapshot.getDQCategoryByName(semanticTypeName);
        if (category == null) {
            if (isSemanticTypeNameAColumn != null && isSemanticTypeNameAColumn.booleanValue()) {
                return null;
            }
            throw new DQCategoryNotFoundException(semanticTypeName);
        }
        if (CategoryType.COMPOUND == category.getType()) {
            category.setChildren(this.completeChildren(dictionarySnapshot, category.getChildren()));
        }
        SemanticQualityAnalyzer analyzer = new SemanticQualityAnalyzer(dictionarySnapshot, new String[0]);
        return analyzer.isValid(category, value);
    }

    private List<DQCategory> completeChildren(DictionarySnapshot dictionarySnapshot, List<DQCategory> children) {
        ArrayList<DQCategory> categories = new ArrayList<DQCategory>();
        for (DQCategory child : children) {
            DQCategory category = dictionarySnapshot.getDQCategoryById(child.getId());
            switch (category.getType()) {
                case DICT: 
                case REGEX: {
                    categories.add(category);
                    break;
                }
                case COMPOUND: {
                    categories.addAll(this.completeChildren(dictionarySnapshot, category.getChildren()));
                    break;
                }
            }
        }
        return categories;
    }
}

