/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.model;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.talend.trr.runtime.Rule;

public class RuleIdentifier {
    private final UUID id;
    private final String name;
    private final Long version;

    private RuleIdentifier(UUID id, String name, Long version) {
        this.id = id;
        this.name = name;
        this.version = version;
    }

    public RuleIdentifier(UUID id, Long version) {
        this(id, null, version);
    }

    public RuleIdentifier(String name, Long version) {
        this(null, name, version);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getVersion() {
        return this.version;
    }

    public Predicate<Rule> asPredicate() {
        return this.id != null ? rule -> rule.getId().equals(this.id) : rule -> rule.getName().equals(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleIdentifier that = (RuleIdentifier)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.version);
    }

    public String toString() {
        return "RuleIdentifier{id=" + this.id + ", name='" + this.name + '\'' + ", version=" + this.version + '}';
    }
}

