/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public final class SemanticTypeUtils {
    public static final Pattern ISOFTYPE_PATTERN = Pattern.compile("isOfType\\((.*?),(.*?)\\)");
    public static final String DELETED_ST_PLACEHOLDER = "DELETED_TYPE__";
    public static final String NON_COMPLETE_ST_PLACEHOLDER = "NON_COMPLETE_TYPE__";

    private SemanticTypeUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<String> getTypeLabels(String expression, String prefix, DictionarySnapshot dictionarySnapshot) {
        Matcher matcher = ISOFTYPE_PATTERN.matcher(expression);
        ArrayList<String> types = new ArrayList<String>();
        while (matcher.find()) {
            types.add(matcher.group(2).trim());
        }
        return types.stream().filter(type -> type.startsWith("'") || type.startsWith("\"")).map(type -> StringUtils.strip(type, "\"'").trim()).filter(type -> type.startsWith(prefix)).map(type -> type.substring(prefix.length())).map(type -> {
            DQCategory dqCategory = dictionarySnapshot.getDQCategoryByName(type);
            return dqCategory == null ? type : dqCategory.getLabel();
        }).collect(Collectors.toSet());
    }
}

