/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;
import org.talend.trr.common.utils.VariableHelper;
import org.talend.trr.runtime.model.Variable;

public final class VariableUtils {
    private VariableUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<String> getVars(Map<String, Variable> variables, Variable.UseContext useCtx) {
        return variables.values().stream().filter(variable -> variable.getUsedIn().contains((Object)useCtx)).map(Variable::getName).collect(Collectors.toSet());
    }

    public static Set<String> extractVariableNames(ELNode node) {
        return VariableHelper.extractVariableNamesFromMaplang(node);
    }

    public static Map<String, Variable> extractVariables(String expression) {
        Set<Variable> vars = VariableHelper.extractVariablesFromMaplang(expression, (node, idx) -> {
            Variable variable = new Variable(node.getImage());
            if (VariableUtils.isCondition(node.getParent())) {
                variable.usedIn(Variable.UseContext.CONDITION);
            } else {
                variable.usedIn(Variable.UseContext.ACTION);
            }
            return variable;
        });
        HashMap<String, Variable> dedupVars = new HashMap<String, Variable>();
        vars.forEach(v -> {
            Variable dedupVar = dedupVars.getOrDefault(v.getName(), (Variable)v);
            dedupVar.getUsedIn().addAll(v.getUsedIn());
            dedupVars.putIfAbsent(v.getName(), dedupVar);
        });
        return dedupVars;
    }

    public static boolean isCondition(ELNode node) {
        return node != null && node.getParent() != null && (node.getParent().getType() == ELNodeType.CONDITION || VariableUtils.isCondition(node.getParent()));
    }
}

