/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.validation;

import java.util.ArrayList;
import java.util.List;
import org.talend.trr.runtime.RuleExecutionResult;
import org.talend.trr.runtime.validation.ValidationResult;

public class ValidationRuleExecutionResult
implements RuleExecutionResult<ValidationResult> {
    private final List<ValidationResult> results = new ArrayList<ValidationResult>();

    @Override
    public List<ValidationResult> getResults() {
        return new ArrayList<ValidationResult>(this.results);
    }

    @Override
    public ValidationResult aggregateResults() {
        int nbResults = this.results.size();
        if (nbResults > 0) {
            if (this.getNbNE() == (long)nbResults) {
                return ValidationResult.NOT_EXECUTABLE;
            }
            if (this.getNbNA() == (long)nbResults) {
                return ValidationResult.NOT_APPLICABLE;
            }
            if (this.getNbNR() == (long)nbResults) {
                return ValidationResult.NO_RESULT;
            }
            if (this.getNbInvalidValues() > 0L || this.getNbNE() > 0L) {
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        return ValidationResult.NO_RESULT;
    }

    public long getNbValidValues() {
        return this.results.stream().filter(result -> result == ValidationResult.VALID).count();
    }

    public long getNbInvalidValues() {
        return this.results.stream().filter(result -> result == ValidationResult.INVALID).count();
    }

    public long getNbNA() {
        return this.results.stream().filter(result -> result == ValidationResult.NOT_APPLICABLE).count();
    }

    public long getNbNE() {
        return this.results.stream().filter(result -> result == ValidationResult.NOT_EXECUTABLE).count();
    }

    public long getNbNR() {
        return this.results.stream().filter(result -> result == ValidationResult.NO_RESULT).count();
    }

    public void addResult(ValidationResult result) {
        this.results.add(result);
    }

    public void init() {
        this.results.clear();
    }
}

