/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.connector.config;

import javax.inject.Named;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.talend.tsd.artifact.client.api.SemanticBundlesApi;
import org.talend.tsd.maven.connector.resttemplate.client.HttpClient;
import org.talend.tsd.maven.connector.resttemplate.config.RestTemplateConnectorConfig;
import org.talend.tsd.maven.connector.resttemplate.config.RestTemplateConnectorProperties;
import org.talend.tsd.maven.connector.resttemplate.service.RestTemplateArtifactService;
import org.talend.tsd.maven.connector.resttemplate.service.RestTemplateJarClient;
import org.talend.tsd.maven.connector.service.JarService;
import org.talend.tsd.utils.RandomFolderNameProvider;

@ConditionalOnProperty(value={"tsd.resttemplate.connector.enabled"}, havingValue="true")
@ConditionalOnClass(value={RestTemplateConnectorProperties.class})
@Configuration
@EnableConfigurationProperties(value={RestTemplateConnectorProperties.class})
public class RestTemplateConnectorAutoConfiguration {
    @Bean(value={"RestTemplateRedirectWithoutAuthorization"})
    @ConditionalOnMissingBean
    public RestTemplate restTemplateFollowRedirect() {
        CloseableHttpClient client = this.clientWithoutAuthorizationHeaderOnRedirect();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(client);
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        restTemplate.setErrorHandler(new DefaultResponseErrorHandler());
        return restTemplate;
    }

    private CloseableHttpClient clientWithoutAuthorizationHeaderOnRedirect() {
        return HttpClientBuilder.create().useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy(){

            @Override
            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                if (super.isRedirected(request, response, context)) {
                    request.removeHeaders("Authorization");
                    return true;
                }
                return false;
            }
        }).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public SemanticBundlesApi semanticBundlesApi(@Named(value="RestTemplateRedirectWithoutAuthorization") RestTemplate restTemplate, RestTemplateConnectorProperties properties) {
        return RestTemplateConnectorConfig.semanticBundlesApi(restTemplate, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpClient httpClient(@Named(value="RestTemplateRedirectWithoutAuthorization") RestTemplate restTemplate, RestTemplateConnectorProperties prop, SemanticBundlesApi semanticBundlesApi) {
        return new HttpClient(restTemplate, prop, semanticBundlesApi);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateJarClient jarProvider(HttpClient httpClient, RestTemplateConnectorProperties properties) {
        return new RestTemplateJarClient(httpClient, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateArtifactService restTemplateArtifactService(RestTemplateConnectorProperties connectorProp, JarService jarService, RandomFolderNameProvider randomFolderNameProvider, RestTemplateJarClient jarProvider) {
        return new RestTemplateArtifactService(jarService, connectorProp, jarProvider, randomFolderNameProvider, null);
    }
}

