/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.maven.connector.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.tsd.maven.connector.exception.JarException;

public class JarService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String JAR_SEPARATOR = "/";

    public void toJar(Path jarFile, Path content) {
        this.ensureParentFolderExist(jarFile);
        try (JarOutputStream output = new JarOutputStream(new FileOutputStream(jarFile.toFile()));){
            File[] files = content.toFile().listFiles();
            if (null != files) {
                for (File file : files) {
                    this.addToJar(output, file, "");
                }
            }
        }
        catch (IOException e) {
            throw new JarException("To jar error", e);
        }
    }

    private void ensureParentFolderExist(Path jarFile) {
        Path parentFolder = jarFile.getParent();
        if (!Files.exists(parentFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new JarException("Can't create parent folder", e);
            }
        }
    }

    private void addToJar(JarOutputStream output, File file, String filePath) {
        if (file.isDirectory()) {
            this.addFolder(filePath, file, output);
        } else {
            this.addFile(filePath, file, output);
        }
    }

    private void addFile(String filePath, File file, JarOutputStream output) {
        this.log.debug("Add file {}{}", (Object)filePath, (Object)file.getName());
        JarEntry entry = this.toJarEntry(filePath, file);
        try {
            output.putNextEntry(entry);
            this.writeFile(file, output);
        }
        catch (IOException e) {
            throw new JarException("Write jar error", e);
        }
    }

    private JarEntry toJarEntry(String filePath, File file) {
        JarEntry entry = new JarEntry(filePath + file.getName());
        entry.setTime(file.lastModified());
        return entry;
    }

    private void writeFile(File file, JarOutputStream output) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = input.read(buffer)) != -1) {
                output.write(buffer, 0, count);
            }
            output.closeEntry();
        }
    }

    private void addFolder(String filePath, File file, JarOutputStream output) {
        this.log.debug("Add folder {}{}", (Object)filePath, (Object)file.getName());
        File[] children = file.listFiles();
        JarEntry entry = new JarEntry(filePath + file.getName() + JAR_SEPARATOR);
        entry.setTime(file.lastModified());
        try {
            output.putNextEntry(entry);
            output.closeEntry();
        }
        catch (IOException e) {
            throw new JarException("Write jar error", e);
        }
        if (null != children) {
            for (File child : children) {
                this.addToJar(output, child, filePath + file.getName() + JAR_SEPARATOR);
            }
        }
    }

    public void extract(JarFile jar, Path targetFolder) {
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            Path path = targetFolder.resolve(file.getName());
            try {
                this.ensureContentFolder(path);
                if (file.isDirectory()) continue;
                this.copy(jar, file, path);
            }
            catch (IOException e) {
                throw new JarException("Jar extraction exception", e);
            }
        }
    }

    private void ensureContentFolder(Path path) throws IOException {
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    private void copy(JarFile jar, JarEntry file, Path path) throws IOException {
        try (InputStream input = jar.getInputStream(file);){
            Files.copy(input, path, new CopyOption[0]);
        }
    }
}

