/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.multitenant.context;

import org.talend.daikon.multitenant.context.DefaultTenancyContext;
import org.talend.daikon.multitenant.context.TenancyContext;
import org.talend.daikon.multitenant.context.TenancyContextHolderStrategy;

public class GlobalTenancyContextHolderStrategy
implements TenancyContextHolderStrategy {
    private static TenancyContext contextHolder;

    @Override
    public void clearContext() {
        contextHolder = null;
    }

    @Override
    public TenancyContext getContext() {
        if (contextHolder == null) {
            contextHolder = new DefaultTenancyContext();
        }
        return contextHolder;
    }

    @Override
    public void setContext(TenancyContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Only non-null TenancyContext instances are permitted");
        }
        contextHolder = context;
    }

    @Override
    public TenancyContext createEmptyContext() {
        return new DefaultTenancyContext();
    }
}

