/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.multitenant.context;

import org.talend.daikon.multitenant.context.DefaultTenancyContext;
import org.talend.daikon.multitenant.context.TenancyContext;
import org.talend.daikon.multitenant.context.TenancyContextHolderStrategy;

final class InheritableThreadLocalTenancyContextHolderStrategy
implements TenancyContextHolderStrategy {
    private static final ThreadLocal<TenancyContext> CONTEXT_HOLDER = new InheritableThreadLocal<TenancyContext>();

    InheritableThreadLocalTenancyContextHolderStrategy() {
    }

    @Override
    public void clearContext() {
        CONTEXT_HOLDER.remove();
    }

    @Override
    public TenancyContext getContext() {
        TenancyContext ctx = CONTEXT_HOLDER.get();
        if (ctx == null) {
            ctx = this.createEmptyContext();
            CONTEXT_HOLDER.set(ctx);
        }
        return ctx;
    }

    @Override
    public void setContext(TenancyContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Only non-null TenancyContext instances are permitted");
        }
        CONTEXT_HOLDER.set(context);
    }

    @Override
    public TenancyContext createEmptyContext() {
        return new DefaultTenancyContext();
    }
}

