/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.talend.maplang.el.interpreter.ExprInterpreterConstants;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.ExprValueException;

public class ExprValueUtils {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;

    public static String unQuote(String s) {
        if (s.length() >= 2) {
            if (s.startsWith("'") && s.endsWith("'")) {
                return s.substring(1, s.length() - 1).replace("\\'", "'");
            }
            if (s.startsWith("\"") && s.endsWith("\"")) {
                return s.substring(1, s.length() - 1).replace("\\\"", "\"");
            }
        }
        return s;
    }

    public static byte[] intToByteArray(int a) {
        byte[] ret = new byte[4];
        ret[3] = (byte)(a & 0xFF);
        ret[2] = (byte)(a >> 8 & 0xFF);
        ret[1] = (byte)(a >> 16 & 0xFF);
        ret[0] = (byte)(a >> 24 & 0xFF);
        return ret;
    }

    public static byte[] stringToByteArray(String s) {
        if (ExprValueUtils.isHexStringCandidate(s)) {
            return ExprValueUtils.hexStringToByteArray(s);
        }
        return s.getBytes(UTF_8);
    }

    public static byte[] hexStringToByteArray(String str) throws ExprValueException {
        if (!ExprValueUtils.isHexStringCandidate(str)) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidHexadecimal", str));
        }
        String hexStr = str.substring(2);
        int len = hexStr.length();
        if (len == 0 || len % 2 != 0) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidHexadecimal", str));
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int digit1 = Character.digit(hexStr.charAt(i), 16);
            int digit2 = Character.digit(hexStr.charAt(i + 1), 16);
            if (digit1 == -1 || digit2 == -1) {
                throw new ExprValueException(Messages.getMessage("ExprValue.invalidHexadecimal", str));
            }
            data[i / 2] = (byte)((digit1 << 4) + digit2);
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer hexStringBuffer = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuffer.append(ExprValueUtils.byteToHex(byteArray[i]).toUpperCase());
        }
        return "0x" + hexStringBuffer.toString();
    }

    public static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    public static boolean isHexStringCandidate(Object value) {
        return value instanceof String && (((String)value).startsWith("0x") || ((String)value).startsWith("0X"));
    }

    public static OffsetDateTime millsToLocalDateTime(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        OffsetDateTime date = instant.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        return date;
    }

    public static LocalDate millsToLocalDate(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        LocalDate date = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        return date;
    }

    public static LocalDate parseToDate(String value) {
        try {
            return LocalDate.parse(value, ExprInterpreterConstants.DATE_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.cannotParseDate", value), e);
        }
    }

    public static LocalTime parseToTime(String value) {
        try {
            return LocalTime.parse(value, DateTimeFormatter.ISO_TIME);
        }
        catch (DateTimeParseException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.cannotParseTime", value), e);
        }
    }

    public static OffsetDateTime parseToDateTime(String value) {
        try {
            return OffsetDateTime.parse(value, ExprInterpreterConstants.DATE_TIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.cannotParseDateTime", value), e);
        }
    }

    public static ZoneOffset getOffset(LocalDate date) {
        return ExprValueUtils.getOffset(date, LocalTime.NOON);
    }

    public static ZoneOffset getOffset(LocalDate date, LocalTime time) {
        LocalDateTime localDateTime = date.atTime(time);
        ZoneId localTimeZone = ZoneId.systemDefault();
        return localTimeZone.getRules().getOffset(localDateTime);
    }

    public static boolean byteArrayToBooleanValue(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            return true;
        }
        return false;
    }
}

