/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function;

import java.util.List;
import org.talend.maplang.el.interpreter.api.CustomOpFunction;
import org.talend.maplang.el.interpreter.api.ExprEvalVisitor;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.ExprLangFunction;
import org.talend.maplang.el.interpreter.api.ExtendedExprLangFunction;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.parser.DSLFunctions;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.model.ELNode;

public class ExprLangFunctions
implements DSLFunctions {
    private final ExprLangContext _context;

    public ExprLangFunctions(ExprLangContext context) {
        this._context = context;
    }

    public ExprValue call(String functionName, ExprValue ... arguments) {
        ExprLangFunction function = this.getFunction(functionName);
        if (function == null) {
            throw new ExprLangFunctionException("ExprInterpreterException.unknownFunction " + functionName);
        }
        Object[] parms = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            parms[i] = arguments[i].getValue();
        }
        return new ExprValue(function.call(this._context, parms));
    }

    public ExprValue callExtended(String functionName, ExprEvalVisitor visitor, ELNode functionNode) {
        ExtendedExprLangFunction extendedFunction = this.getExtendedFunction(functionName);
        if (extendedFunction == null) {
            throw new ExprLangFunctionException("ExprInterpreterException.unknownFunction " + functionName);
        }
        List<ELNode> children = functionNode.getChildren();
        ELNode[] argNodes = children.toArray(new ELNode[children.size()]);
        return new ExprValue(extendedFunction.call(visitor, argNodes));
    }

    @Override
    public boolean isDefinedFunction(String functionName) {
        return this.getFunction(functionName) != null;
    }

    @Override
    public boolean isVisibleFunction(String functionName) {
        ExprLangFunction function = this.getFunction(functionName);
        if (function != null) {
            if (function instanceof CustomOpFunction) {
                return ((CustomOpFunction)function).isVisible();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isExtendedFunction(String functionName) {
        ExprLangFunction function = this.getFunction(functionName);
        return function instanceof ExtendedExprLangFunction;
    }

    @Override
    public void validateArguments(DslContent dslContent, String functionName, ELNode functionNode) {
        ExtendedExprLangFunction extendedFunction = this.getExtendedFunction(functionName);
        List<ELNode> children = functionNode.getChildren();
        extendedFunction.validateArguments(dslContent, children.toArray(new ELNode[children.size()]));
    }

    public ExprLangFunction getFunction(String functionName) {
        return this._context.getFunctions().get(functionName.toLowerCase());
    }

    public ExtendedExprLangFunction getExtendedFunction(String functionName) {
        return (ExtendedExprLangFunction)this.getFunction(functionName);
    }
}

