/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function;

import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class TimeoutCharSequence
implements CharSequence {
    private static final int CHECK_EVERY = 1000000;
    private int counter = 0;
    private int nextCounter = 0;
    private final long timeout;
    private final long startTime;
    private final CharSequence inner;

    public TimeoutCharSequence(CharSequence inner, long timeout) {
        this.inner = inner;
        this.timeout = timeout;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public char charAt(int index) {
        this.checkForTimeout();
        return this.inner.charAt(index);
    }

    @Override
    public int length() {
        return this.inner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new TimeoutCharSequence(this.inner.subSequence(start, end), this.timeout);
    }

    @Override
    public String toString() {
        return this.inner.toString();
    }

    public void checkForTimeout() {
        if (this.counter++ == this.nextCounter) {
            this.nextCounter += 1000000;
            if (System.currentTimeMillis() - this.startTime >= this.timeout) {
                throw new ExprLangFunctionException(Messages.getMessage("TimeoutCharSequence.TimedOut", this.timeout));
            }
        }
    }
}

