/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.WeekFields;
import java.util.Locale;
import org.talend.maplang.el.interpreter.ExprInterpreterConstants;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class ExtractFromDateTime
extends AbstractExprLangFunction {
    public static final String NAME = "extractFromDateTime";
    private static final Class<?>[] RESULT_CLASSES = new Class[]{RESULT_DATE_CLASS, RESULT_TIME_CLASS, RESULT_INTEGER_CLASS, RESULT_LONG_CLASS, RESULT_STRING_CLASS};

    public ExtractFromDateTime() {
        super(NAME, RESULT_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, OffsetDateTime.class, String.class, LocalDate.class);
        this.checkArgumentClass(parms, 1, (Class<?>)String.class);
        String what = (String)parms[1];
        OffsetDateTime datetime = this.exprValue(parms[0]).dateTimeValue();
        ExprInterpreterConstants.DateTimeConstantType valueWhat = ExprInterpreterConstants.DateTimeConstantType.getType(what);
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        try {
            switch (valueWhat) {
                case DATE: {
                    return datetime.toLocalDate();
                }
                case TIME: {
                    return datetime.toLocalTime();
                }
                case YEAR: {
                    return datetime.getYear();
                }
                case MONTH: {
                    return datetime.getMonthValue();
                }
                case HOUR: {
                    return datetime.getHour();
                }
                case MINUTE: {
                    return datetime.getMinute();
                }
                case SECOND: {
                    return datetime.getSecond();
                }
                case MILLISECOND: {
                    BigInteger nano = BigInteger.valueOf(datetime.getNano());
                    BigDecimal bd = new BigDecimal(nano, 6);
                    return bd.intValue();
                }
                case EPOCHSECOND: {
                    return datetime.toEpochSecond();
                }
                case TIMEZONE: {
                    return datetime.getOffset().getId();
                }
                case DAY: {
                    return datetime.getDayOfMonth();
                }
                case DAY_OF_YEAR: {
                    return datetime.getDayOfYear();
                }
                case DAY_OF_WEEK: {
                    return datetime.getDayOfWeek().getValue();
                }
                case WEEK_OF_YEAR: {
                    return datetime.get(weekFields.weekOfWeekBasedYear());
                }
                case WEEK: {
                    return datetime.get(weekFields.weekOfMonth());
                }
            }
            throw new ExprLangFunctionException(Messages.getMessage("ExprValue.NotSupportedDateTimeType", what));
        }
        catch (Exception ex) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidDateTimeOperation", new Object[0]));
        }
    }
}

