/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.regex.PatternSyntaxException;
import org.talend.maplang.el.interpreter.api.CustomOpFunction;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Like
extends AbstractExprLangFunction
implements CustomOpFunction {
    public static final String NAME = "like";
    public static final String[] OPERATORS = new String[]{"like"};

    public Like() {
        super(NAME, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public CustomOpFunction.Kind getKind() {
        return CustomOpFunction.Kind.BINARY;
    }

    @Override
    public String getOperator(int position) {
        return OPERATORS[position];
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2);
        Boolean result = null;
        try {
            result = Like.like(parms[0], parms[1]);
        }
        catch (ExprValueException e) {
            throw new ExprLangFunctionException(e.getMessage());
        }
        return result;
    }

    public static boolean like(Object value, Object sqlPattern) {
        String strVal = new ExprValue(value).stringValue();
        String pattern = new ExprValue(sqlPattern).stringValue();
        pattern = pattern.replace("\\", "\\\\");
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("*", "\\*");
        pattern = pattern.replace("?", "\\?");
        pattern = pattern.replace(",", "\\,");
        pattern = pattern.replace("{", "\\{");
        pattern = pattern.replace("}", "\\}");
        pattern = pattern.replace("$", "\\$");
        pattern = pattern.replace("|", "\\|");
        if ((pattern = pattern.replace("+", "\\+")).startsWith("^")) {
            pattern = pattern.replace("^", "\\^");
        }
        pattern = pattern.replace("%", ".*");
        pattern = pattern.replace("_", ".");
        try {
            return strVal.matches(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ExprLangFunctionException(e.getMessage());
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }
}

