/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.util.Arrays;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Right
extends AbstractExprLangFunction {
    public static final String NAME = "right";

    public Right() {
        super(NAME, RESULT_STRING_OR_BYTES_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        int length;
        this.checkNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, String.class, Number.class, byte[].class);
        this.checkArgumentClass(parms, 1, String.class, Number.class, byte[].class);
        try {
            length = this.exprValue(parms[1]).intValue();
        }
        catch (ExprValueException e) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.functionCallError", this.getName(), e.getMessage()));
        }
        this.checkInvalidNegativeIntArgumentByIndex(length, 1);
        if (parms[0] instanceof byte[]) {
            byte[] bytes = (byte[])parms[0];
            if (length > bytes.length) {
                byte[] result = new byte[length];
                System.arraycopy(bytes, 0, result, length - bytes.length, bytes.length);
                return result;
            }
            if (length == bytes.length) {
                return bytes;
            }
            int beginIndex = bytes.length - length;
            return Arrays.copyOfRange(bytes, beginIndex, bytes.length);
        }
        String input = this.stringValue(parms[0]);
        if (length > input.length()) {
            int extraLength = length - input.length();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < extraLength; ++i) {
                buf.append(" ");
            }
            buf.append(input);
            return buf.toString();
        }
        if (length == input.length()) {
            return input;
        }
        int beginIndex = input.length() - length;
        return input.substring(beginIndex);
    }
}

