/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.talend.maplang.el.interpreter.impl.ExprValueUtils;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class ToDateTime
extends AbstractExprLangFunction {
    public static final String NAME = "toDateTime";

    public ToDateTime() {
        super(NAME, RESULT_DATETIME_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkMinimalNbrOfArguments(parms, 1);
        this.checkMaximalNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, String.class, LocalDate.class, OffsetDateTime.class);
        if (this.exprValue(parms[0]).isDate() && parms.length > 1) {
            this.checkArgumentClass(parms, 1, String.class, LocalTime.class);
            LocalDate date = (LocalDate)parms[0];
            LocalTime specifiedLocalTime = this.exprValue(parms[1]).timeValue();
            ZoneOffset offset = ExprValueUtils.getOffset(date, specifiedLocalTime);
            LocalDateTime time = date.atTime(specifiedLocalTime);
            return OffsetDateTime.of(time, offset);
        }
        return this.exprValue(parms[0]).dateTimeValue();
    }
}

