/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class ToDecimal
extends AbstractExprLangFunction {
    public static final String NAME = "toDecimal";

    public ToDecimal() {
        super(NAME, RESULT_DECIMAL_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkMinimalNbrOfArguments(parms, 1);
        BigDecimal value = this.exprValue(parms[0]).bigDecimalValue();
        if (parms.length > 1) {
            this.checkArgumentClass(parms, 1, String.class, Number.class);
            int scale = this.exprValue(parms[1]).intValue();
            RoundingMode roundingMode = RoundingMode.FLOOR;
            if (parms.length == 3) {
                this.checkArgumentClass(parms, 2, String.class, Number.class);
                try {
                    if (String.class.isAssignableFrom(parms[2].getClass())) {
                        String mode = (String)parms[2];
                        roundingMode = RoundingMode.valueOf(mode.toUpperCase());
                    } else {
                        roundingMode = RoundingMode.valueOf(this.exprValue(parms[2]).intValue());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentValues", this.getName(), 2));
                }
            }
            try {
                value = value.setScale(scale, roundingMode);
            }
            catch (ArithmeticException e) {
                throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.functionCallError", this.getName(), e.getMessage()));
            }
        }
        return value;
    }
}

