/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.DslEscapeUtils;
import org.talend.maplang.el.parser.Location;
import org.talend.maplang.el.parser.Messages;

public class DSLException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Location location = null;
    private DslContent dslContent;
    protected static final String SPACE = " ";
    protected static final String MSG_PTIES_PREFIX = "DSL.";

    public DSLException() {
    }

    public DSLException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public DSLException(String msg) {
        super(msg);
    }

    public DSLException(String msg, DslContent dslContent, Location location) {
        super(msg);
        this.dslContent = dslContent;
        this.location = location;
    }

    public DSLException(Throwable cause) {
        super(cause);
    }

    public void setLocationAndDslContent(Location location, DslContent dslContent) {
        this.location = location;
        this.dslContent = dslContent;
    }

    public Location getLocation() {
        return this.location;
    }

    public DslContent getDslContent() {
        return this.dslContent;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage(super.getMessage());
    }

    protected String getErrorMessage(String exceptionMsg) {
        String errorMsg;
        StringBuilder buf = new StringBuilder();
        if (this.location != null) {
            Location loc = this.location;
            if (this.dslContent != null && this.dslContent.isEscaped()) {
                loc = this.dslContent.adapt(loc);
            }
            buf.append(Messages.getMessage("DSL.errorLocation", loc.getLine(), loc.getColumn()));
            buf.append(SPACE);
        }
        if (DslEscapeUtils.isEscaped(errorMsg = exceptionMsg)) {
            errorMsg = DslEscapeUtils.unescape(errorMsg);
        }
        buf.append(errorMsg);
        return buf.toString();
    }
}

