/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.ExprLangConstants;
import org.talend.maplang.el.parser.ExprLangLexer;
import org.talend.maplang.el.parser.FileLineMap;
import org.talend.maplang.el.parser.InvalidToken;
import org.talend.maplang.el.parser.Location;
import org.talend.maplang.el.parser.Messages;
import org.talend.maplang.el.parser.ParseException;
import org.talend.maplang.el.parser.Token;
import org.talend.maplang.el.parser.internal.ParseExceptionDetails;
import org.talend.maplang.el.parser.internal.ParsingContext;
import org.talend.maplang.el.parser.internal.ParsingContextException;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;

public class ExprLangParser
implements ExprLangConstants {
    private static final String PARSER_NAME = "ExprLangParser";
    private DslContent dslContent;
    public static final boolean MANDATORY = false;
    public static final boolean OPTIONAL = true;
    public static final String SPACE = " ";
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NOT_KEYWORD = "not";
    public static final String IF_THEN_ELSE = "ifThenElse";
    public static final String IF = "if";
    public static final String THEN = "then";
    public static final String ELSEIF = "elseif";
    public static final String ELSE = "else";
    public static final String SWITCH = "switch";
    public static final String CASE = "case";
    public static final String DEFAULT = "default";
    public static final String LET = "let";
    public static final String JAVA = "java";
    public static final String CALL = "call";
    public static final String NEW = "new";
    public static final String JAVA_CALL = "java:call";
    public static final String JAVA_NEW = "java:new";
    public static final String ARRAY = "[..]";
    private ParsingContext parsingContext;
    private static final Logger LOGGER = Logger.getLogger(ExprLangParser.class.getName());
    static final int UNLIMITED = Integer.MAX_VALUE;
    Token lastConsumedToken = new Token();
    private ExprLangConstants.TokenType nextTokenType;
    private Token currentLookaheadToken;
    private int remainingLookahead;
    private boolean scanToEnd;
    private boolean hitFailure;
    private boolean lastLookaheadSucceeded;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    private int lookaheadRoutineNesting;
    private EnumSet<ExprLangConstants.TokenType> outerFollowSet;
    private boolean cancelled;
    public ExprLangLexer token_source;
    private static final EnumSet<ExprLangConstants.TokenType> multOp_FIRST_SET = EnumSet.of(ExprLangConstants.TokenType.SLASH, ExprLangConstants.TokenType.STAR, ExprLangConstants.TokenType.MOD);
    private static final EnumSet<ExprLangConstants.TokenType> addOp_FIRST_SET = EnumSet.of(ExprLangConstants.TokenType.MINUS, ExprLangConstants.TokenType.PLUS);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$744$5 = EnumSet.of(ExprLangConstants.TokenType.INTEGER_LITERAL, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$796$4 = EnumSet.of(ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$818$64 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$853$40 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$867$5$ = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$867$5 = EnumSet.of(ExprLangConstants.TokenType.INTEGER_LITERAL, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$872$5 = EnumSet.of(ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$909$4 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$910$6 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$924$5 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$942$5 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1026$29 = EnumSet.of(ExprLangConstants.TokenType.SLASH, ExprLangConstants.TokenType.STAR, ExprLangConstants.TokenType.MOD);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1070$24 = EnumSet.of(ExprLangConstants.TokenType.MINUS, ExprLangConstants.TokenType.PLUS);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1085$4 = EnumSet.of(ExprLangConstants.TokenType.EQ_1, ExprLangConstants.TokenType.EQ_2);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1151$5 = EnumSet.of(ExprLangConstants.TokenType.LT, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.GT, ExprLangConstants.TokenType.LE, ExprLangConstants.TokenType.GE, ExprLangConstants.TokenType.EQ_1, ExprLangConstants.TokenType.EQ_2, ExprLangConstants.TokenType.NE});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1165$24 = EnumSet.of(ExprLangConstants.TokenType.LT, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.GT, ExprLangConstants.TokenType.LE, ExprLangConstants.TokenType.GE, ExprLangConstants.TokenType.EQ_1, ExprLangConstants.TokenType.EQ_2, ExprLangConstants.TokenType.NE});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1165$24$ = EnumSet.of(ExprLangConstants.TokenType.LT, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.GT, ExprLangConstants.TokenType.LE, ExprLangConstants.TokenType.GE, ExprLangConstants.TokenType.EQ_1, ExprLangConstants.TokenType.EQ_2, ExprLangConstants.TokenType.NE});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1258$4$ = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_CURLY_BRACKET, ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1258$4 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1269$4$ = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_CURLY_BRACKET, ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1269$4 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1341$7$ = EnumSet.of(ExprLangConstants.TokenType.INTEGER_LITERAL, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1341$7 = EnumSet.of(ExprLangConstants.TokenType.INTEGER_LITERAL, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1351$18 = EnumSet.of(ExprLangConstants.TokenType.INTEGER_LITERAL, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1374$5 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1420$4 = EnumSet.of(ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1434$16 = EnumSet.of(ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1450$3 = EnumSet.of(ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1465$6 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1477$5 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1481$5 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> first_set$el_jj$1490$29 = EnumSet.of(ExprLangConstants.TokenType.COMMA, ExprLangConstants.TokenType.SEMICOLON);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$806$2 = EnumSet.of(ExprLangConstants.TokenType.COMMA);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$806$28 = EnumSet.of(ExprLangConstants.TokenType.COMMA);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$818$64$ = EnumSet.of(ExprLangConstants.TokenType.RIGHT_PAREN);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$840$15 = EnumSet.of(ExprLangConstants.TokenType.RIGHT_PAREN);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$853$40$ = EnumSet.of(ExprLangConstants.TokenType.RIGHT_SQ_BRACKET);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$884$4 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$942$44 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$942$78 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$942$95 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$943$43 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$970$3 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1026$4 = EnumSet.of(ExprLangConstants.TokenType.SLASH, ExprLangConstants.TokenType.STAR, ExprLangConstants.TokenType.MOD);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1026$29 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1026$46 = EnumSet.of(ExprLangConstants.TokenType.SLASH, ExprLangConstants.TokenType.STAR, ExprLangConstants.TokenType.MOD);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1070$4 = EnumSet.of(ExprLangConstants.TokenType.MINUS, ExprLangConstants.TokenType.PLUS);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1070$24 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1070$39 = EnumSet.of(ExprLangConstants.TokenType.MINUS, ExprLangConstants.TokenType.PLUS);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1165$4 = EnumSet.of(ExprLangConstants.TokenType.LT, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.GT, ExprLangConstants.TokenType.LE, ExprLangConstants.TokenType.GE, ExprLangConstants.TokenType.EQ_1, ExprLangConstants.TokenType.EQ_2, ExprLangConstants.TokenType.NE});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1165$24$ = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1191$4 = EnumSet.of(ExprLangConstants.TokenType.AND);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1191$28 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1191$45 = EnumSet.of(ExprLangConstants.TokenType.AND);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1217$4 = EnumSet.of(ExprLangConstants.TokenType.OR);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1217$27 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1217$43 = EnumSet.of(ExprLangConstants.TokenType.OR);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1258$47 = EnumSet.of(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1269$47 = EnumSet.of(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1280$2 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1280$18 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_CURLY_BRACKET, ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1296$2 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_CURLY_BRACKET, ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1312$4 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1319$2 = EnumSet.of(ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1328$3 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1328$15 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_CURLY_BRACKET, ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1351$4 = EnumSet.of(ExprLangConstants.TokenType.INTEGER_LITERAL, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1351$18 = EnumSet.of(ExprLangConstants.TokenType.COLON);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1362$4 = EnumSet.of(ExprLangConstants.TokenType.COLON);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1385$3 = EnumSet.of(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1396$3 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1396$19 = EnumSet.of(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1434$3 = EnumSet.of(ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1434$16 = EnumSet.of(ExprLangConstants.TokenType.EQ_1);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1434$53 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1450$3 = EnumSet.of(ExprLangConstants.TokenType.EQ_1);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1450$40 = EnumSet.of(ExprLangConstants.TokenType.LEFT_PAREN, new ExprLangConstants.TokenType[]{ExprLangConstants.TokenType.LEFT_SQ_BRACKET, ExprLangConstants.TokenType.NOT, ExprLangConstants.TokenType.INTEGER_LITERAL, ExprLangConstants.TokenType.LONG_LITERAL, ExprLangConstants.TokenType.DECIMAL_LITERAL, ExprLangConstants.TokenType.DOUBLE_LITERAL, ExprLangConstants.TokenType.FLOAT_LITERAL, ExprLangConstants.TokenType.BYTES_LITERAL, ExprLangConstants.TokenType.STRING_LITERAL, ExprLangConstants.TokenType.VARIABLE, ExprLangConstants.TokenType.HPATH});
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1490$4 = EnumSet.of(ExprLangConstants.TokenType.COMMA, ExprLangConstants.TokenType.SEMICOLON);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1490$53 = EnumSet.of(ExprLangConstants.TokenType.COMMA, ExprLangConstants.TokenType.SEMICOLON);
    private static final EnumSet<ExprLangConstants.TokenType> follow_set$el_jj$1501$2 = EnumSet.of(ExprLangConstants.TokenType.EOF);
    private boolean trace_enabled = false;
    ArrayList<NonTerminalCall> parsingStack = new ArrayList();
    private ArrayList<NonTerminalCall> lookaheadStack = new ArrayList();

    private String getMessage(String msgId, Object ... args) {
        String fullMsgId = "ExprLangParser." + msgId;
        return Messages.getMessage(fullMsgId, args);
    }

    private String getErrorLocationMessage(Token token, String errorMessage) {
        StringBuilder buf = new StringBuilder();
        buf.append(Messages.getMessage("ExprParserError.errorLocation", token.getBeginLine(), token.getBeginColumn()));
        buf.append(SPACE);
        buf.append(errorMessage);
        return buf.toString();
    }

    private ELNodeType getType(Token token) throws ParseException {
        ExprLangConstants.TokenType tokenType = token.getType();
        switch (tokenType) {
            case BYTES_LITERAL: {
                return ELNodeType.BYTES_LITERAL;
            }
            case STRING_LITERAL: {
                return ELNodeType.STRING_LITERAL;
            }
            case DOUBLE_LITERAL: {
                return ELNodeType.DOUBLE_LITERAL;
            }
            case FLOAT_LITERAL: {
                return ELNodeType.FLOAT_LITERAL;
            }
            case LONG_LITERAL: {
                return ELNodeType.LONG_LITERAL;
            }
            case INTEGER_LITERAL: {
                return ELNodeType.INTEGER_LITERAL;
            }
            case DECIMAL_LITERAL: {
                return ELNodeType.DECIMAL_LITERAL;
            }
            case OR: {
                return ELNodeType.OR;
            }
            case AND: {
                return ELNodeType.AND;
            }
            case NOT: {
                return ELNodeType.NOT;
            }
            case EQ_1: 
            case EQ_2: {
                return ELNodeType.EQUAL;
            }
            case NE: {
                return ELNodeType.NOT_EQUAL;
            }
            case GT: {
                return ELNodeType.GREATER_THAN;
            }
            case GE: {
                return ELNodeType.GREATER_OR_EQUAL;
            }
            case LT: {
                return ELNodeType.LOWER_THAN;
            }
            case LE: {
                return ELNodeType.LOWER_OR_EQUAL;
            }
            case PLUS: {
                return ELNodeType.PLUS;
            }
            case MINUS: {
                return ELNodeType.MINUS;
            }
            case STAR: {
                return ELNodeType.MULTIPLY;
            }
            case SLASH: {
                return ELNodeType.DIVIDE;
            }
            case MOD: {
                return ELNodeType.MODULO;
            }
            case HPATH: {
                return ELNodeType.HPATH;
            }
            case VARIABLE: {
                return ELNodeType.VARIABLE;
            }
        }
        throw new ParseException(this.getErrorLocationMessage(token, this.getMessage("invalidTokenType", new Object[]{tokenType})));
    }

    private void checkNotKeyword(Token token) throws ParseException {
        String identifier = token.getImage();
        if (this.isKeyword(identifier, NULL, TRUE, FALSE, IF, ELSEIF, ELSE, SWITCH, CASE, DEFAULT, JAVA, CALL, NEW, NOT_KEYWORD)) {
            throw new ParseException(this.getErrorLocationMessage(token, this.getMessage("invalidIdentifier", identifier)));
        }
    }

    public void setDslContent(DslContent dslContent) {
        this.dslContent = dslContent;
    }

    public String getTokenImage(ExprLangConstants.TokenType tokenType) {
        int tokenIndex = this.getTokenIndex(tokenType);
        String token = tokenImage[tokenIndex];
        return token.replaceAll("\"", "");
    }

    private int getTokenIndex(ExprLangConstants.TokenType tokenType) {
        ExprLangConstants.TokenType[] tokenTypes = ExprLangConstants.TokenType.values();
        for (int i = 0; i < tokenTypes.length; ++i) {
            if (tokenTypes[i] != tokenType) continue;
            return i;
        }
        return -1;
    }

    public boolean hasLastConsumedToken() {
        return this.lastConsumedToken != null;
    }

    public Token getLastConsumedToken() {
        return this.lastConsumedToken;
    }

    public void setParsingContext(ParsingContext parsingContext) {
        this.parsingContext = parsingContext;
    }

    public ParsingContext getParsingContext() throws ParsingContextException {
        if (this.parsingContext == null) {
            throw new ParsingContextException(this.getMessage("parsingContextMissing", new Object[0]));
        }
        return this.parsingContext;
    }

    private void expectingOperator(boolean optional, String operator) throws ParseException {
        try {
            this.getParsingContext().expectingOperator(optional, operator);
        }
        catch (ParsingContextException e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void consumeOperator() throws ParseException {
        try {
            this.getParsingContext().consumeOperator();
        }
        catch (ParsingContextException e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void expectingKeyword(boolean optional, String ... expected) throws ParseException {
        try {
            this.parsingContext.expectingKeyword(optional, expected);
        }
        catch (ParsingContextException e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void consumeKeyword(String keyword) throws ParseException {
        try {
            this.parsingContext.consumeKeyword(keyword);
        }
        catch (ParsingContextException e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void clearExpectedItems() throws ParseException {
        try {
            this.getParsingContext().clearExpectedItems();
        }
        catch (ParsingContextException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public ParseExceptionDetails getExceptionDetails(final ParseException parseException) {
        return new ParseExceptionDetails(){

            @Override
            public String getMessage() {
                return parseException.getMessage();
            }

            @Override
            public boolean hasToken() {
                return parseException.getLastToken() != null;
            }

            @Override
            public boolean isInvalidToken() {
                return parseException.getLastToken() instanceof InvalidToken;
            }

            @Override
            public String getTokenImage() {
                return parseException.getLastToken().getImage();
            }

            @Override
            public String getTokenType() {
                return parseException.getLastToken().getType().name();
            }

            @Override
            public Location getLastLocation() {
                Token lastToken = parseException.getLastToken();
                if (lastToken != null) {
                    return lastToken.getLocation();
                }
                return null;
            }

            @Override
            public boolean hasExpectedTokens() {
                return parseException.getExpectedTokens() != null;
            }

            @Override
            public List<String> getExpectedTokens() {
                ArrayList<String> result = new ArrayList<String>();
                EnumSet<ExprLangConstants.TokenType> expectedTokens = parseException.getExpectedTokens();
                if (expectedTokens != null) {
                    for (ExprLangConstants.TokenType expectedToken : expectedTokens) {
                        result.add(expectedToken.toString());
                    }
                }
                return result;
            }

            @Override
            public boolean hasLastConsumedToken() {
                return ExprLangParser.this.lastConsumedToken != null;
            }

            @Override
            public String getLastConsumedTokenType() {
                if (ExprLangParser.this.lastConsumedToken != null) {
                    return ExprLangParser.this.lastConsumedToken.getType().name();
                }
                return null;
            }

            @Override
            public String getLastConsumedTokenImage() {
                if (ExprLangParser.this.lastConsumedToken != null) {
                    return ExprLangParser.this.lastConsumedToken.getImage();
                }
                return null;
            }

            @Override
            public boolean hasNextToken() {
                return ExprLangParser.this.getToken(1) != null;
            }

            @Override
            public String getNextTokenType() {
                Token nextToken = ExprLangParser.this.getToken(1);
                if (nextToken != null) {
                    return nextToken.getType().name();
                }
                return null;
            }

            @Override
            public String getNextTokenImage() {
                Token nextToken = ExprLangParser.this.getToken(1);
                return nextToken != null ? nextToken.getImage() : null;
            }
        };
    }

    private ELNode setBeginLocation(ELNode node, Token token) {
        if (token.hasValidLocation()) {
            node.setBeginLocation(token.getBeginLine(), token.getBeginColumn());
        }
        return node;
    }

    private ELNode addFunctionCall(ELNode node, Token functionToken, ELNode argsNode) throws ParseException {
        String functionName = functionToken.getImage();
        if (!this.getParsingContext().isDefinedFunction(functionName) || !this.getParsingContext().isVisibleFunction(functionName)) {
            throw new ParseException(this.getErrorLocationMessage(functionToken, this.getMessage("unknownFunction", functionName)));
        }
        return this.setBeginLocation(node.addFunctionCall(functionName, argsNode), functionToken);
    }

    private boolean isJavaCall(Token token1, Token token2) {
        return JAVA.equals(token1.getImage()) && CALL.equals(token2.getImage());
    }

    private boolean isJavaNew(Token token1, Token token2) {
        return JAVA.equals(token1.getImage()) && NEW.equals(token2.getImage());
    }

    private ELNode addJavaCall(ELNode node, Token functionToken, ELNode argsNode) {
        return this.setBeginLocation(node.addFunctionCall(JAVA_CALL, argsNode), functionToken);
    }

    private ELNode addJavaNew(ELNode node, Token functionToken, ELNode argsNode) {
        return this.setBeginLocation(node.addFunctionCall(JAVA_NEW, argsNode), functionToken);
    }

    private boolean isPossibleValidOpToken(Token token) {
        return token != null && token.getType() == ExprLangConstants.TokenType.HPATH && token.getImage() != null && token.getImage().indexOf(".") < 0;
    }

    private String getNextCustomOpName() {
        Token next3;
        Token next2;
        String op = null;
        String op1 = null;
        String op2 = null;
        String op3 = null;
        Token next1 = this.getToken(1);
        if (this.isPossibleValidOpToken(next1) && this.isCustomOperator(op1 = next1.getImage().toLowerCase())) {
            op = op1;
        }
        if (this.isPossibleValidOpToken(next2 = this.getToken(2))) {
            op2 = next2.getImage().toLowerCase();
            String compositeOp = op1 + SPACE + op2;
            if (this.isCustomOperator(compositeOp)) {
                op = compositeOp;
            }
        }
        if (this.isPossibleValidOpToken(next3 = this.getToken(3))) {
            op3 = next3.getImage().toLowerCase();
            String compositeOp = op1 + SPACE + op2 + SPACE + op3;
            if (this.isCustomOperator(compositeOp)) {
                op = compositeOp;
            }
        }
        return op;
    }

    private boolean nextIsCustomOp(String opName) {
        return opName != null;
    }

    private boolean isCustomOperator(String opName) {
        return this.getParsingContext().isUnaryOperator(opName) || this.getParsingContext().isBinaryOperator(opName) || this.getParsingContext().isTernaryOperator(opName);
    }

    private boolean nextIsUnaryOp(String opName) {
        return this.getParsingContext().isUnaryOperator(opName);
    }

    private boolean nextIsBinaryOp(String opName) {
        return this.getParsingContext().isBinaryOperator(opName);
    }

    private boolean nextIsTernaryOp(String opName) {
        return this.getParsingContext().isTernaryOperator(opName);
    }

    private boolean checkNbrOfCustomOpToken(String opName, int position, int expectedNbr) {
        return this.getParsingContext().getNbrOfCustomOp(opName, position) == expectedNbr;
    }

    private void checkCustomOp(String opName, int position, Token opToken1, Token opToken2, Token opToken3) throws ParseException {
        String[] operators = this.getParsingContext().getCustomOperators(opName, position);
        String op1 = null;
        String op2 = null;
        String op3 = null;
        if (operators.length > 0 && !(op1 = opToken1.getImage()).toLowerCase().equals(operators[0])) {
            throw new ParseException(this.getErrorLocationMessage(opToken1, this.getMessage("invalidOperator", op1, operators[0].toUpperCase())));
        }
        if (operators.length > 1 && !(op2 = opToken2.getImage()).toLowerCase().equals(operators[1])) {
            throw new ParseException(this.getErrorLocationMessage(opToken2, this.getMessage("invalidOperator", op2, operators[1].toUpperCase())));
        }
        if (operators.length > 2 && !(op3 = opToken3.getImage()).toLowerCase().equals(operators[2])) {
            throw new ParseException(this.getErrorLocationMessage(opToken3, this.getMessage("invalidOperator", op3, operators[2].toUpperCase())));
        }
        if (operators.length == 0 || operators.length > 3) {
            throw new ParseException(this.getMessage("unsupportedOperator", opName));
        }
    }

    private void addCustomOpNode(ELNode node, Token opToken1, Token opToken2, Token opToken3) {
        String opImage = opToken1.getImage();
        if (opToken2 != null) {
            opImage = opImage + SPACE + opToken2.getImage();
            if (opToken3 != null) {
                opImage = opImage + SPACE + opToken3.getImage();
            }
        }
        ELNode opNode = new ELNode(ELNodeType.NONE, opImage);
        node.addChild(opNode);
    }

    private String finalizeCustomOp(ELNode opNode, ELNode argsNode) {
        String funcName = null;
        for (ELNode node : opNode.getChildren()) {
            if (node.getType() == ELNodeType.NONE) {
                if (funcName != null) continue;
                funcName = this.getParsingContext().getCustomOpFunctionName(node.getImage());
                continue;
            }
            argsNode.addChild(node);
        }
        return funcName;
    }

    private void convertCustomOpToFunctionCall(ELNode node, ELNode opNode, Token token) {
        ELNode argsNode = new ELNode();
        String funcName = this.finalizeCustomOp(opNode, argsNode);
        this.setBeginLocation(node.addFunctionCall(funcName, argsNode), token);
    }

    private boolean hasImage(Token token) {
        return token != null && token.getImage() != null;
    }

    private boolean nextKeyword(String ... keyword) {
        Token next = this.getToken(1);
        return this.hasImage(next) ? this.isKeyword(next.getImage(), keyword) : false;
    }

    private void checkKeyword(Token token, String ... expected) throws ParseException {
        String keyword = token.getImage();
        if (!this.isKeyword(keyword, expected)) {
            throw new ParseException(this.getErrorLocationMessage(token, this.getMessage("invalidKeyword", keyword)));
        }
    }

    private boolean isKeyword(String value, String ... keywords) {
        for (String keyword : keywords) {
            if (!keyword.toLowerCase().equals(value.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void addTokenNode(ELNode node, Token token) throws ParseException {
        this.addTokenNode(node, token, token.getImage());
    }

    private void addTokenNode(ELNode node, Token token, String image) throws ParseException {
        ELNodeType nodeType = this.getType(token);
        ELNode child = new ELNode(nodeType, image);
        node.addChild(this.setBeginLocation(child, token));
    }

    public static void setLogLevel(Level level) {
        LOGGER.setLevel(level);
        Logger.getGlobal().getParent().getHandlers()[0].setLevel(level);
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setInputSource(String inputSource) {
        this.token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return this.token_source.getInputSource();
    }

    public ExprLangParser(String inputSource, CharSequence content) {
        this(new ExprLangLexer(inputSource, content));
    }

    public ExprLangParser(CharSequence content) {
        this("input", content);
    }

    public ExprLangParser(String inputSource, Path path) throws IOException {
        this(inputSource, FileLineMap.stringFromBytes(Files.readAllBytes(path)));
    }

    public ExprLangParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    public ExprLangParser(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public ExprLangParser(Reader reader) {
        this(new ExprLangLexer("input", reader));
    }

    public ExprLangParser(ExprLangLexer lexer) {
        this.token_source = lexer;
        this.lastConsumedToken.setInputSource(lexer.getInputSource());
    }

    private final Token nextToken(Token tok) {
        Token result = tok == null ? null : tok.getNext();
        Token previous = null;
        while (result == null) {
            Token next;
            this.nextTokenType = null;
            previous = next = this.token_source.getNextToken();
            if (!next.isUnparsed()) {
                result = next;
                continue;
            }
            if (!(next instanceof InvalidToken)) continue;
            result = next.getNextToken();
        }
        if (tok != null) {
            tok.setNext(result);
        }
        this.nextTokenType = null;
        return result;
    }

    public final Token getNextToken() {
        return this.getToken(1);
    }

    public final Token getToken(int index) {
        Token t = this.currentLookaheadToken == null ? this.lastConsumedToken : this.currentLookaheadToken;
        for (int i = 0; i < index; ++i) {
            t = this.nextToken(t);
        }
        return t;
    }

    private final ExprLangConstants.TokenType nextTokenType() {
        if (this.nextTokenType == null) {
            this.nextTokenType = this.nextToken(this.lastConsumedToken).getType();
        }
        return this.nextTokenType;
    }

    public final void longLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 661 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "longLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.LONG_LITERAL);
        this.addTokenNode(node, token);
    }

    public final void integerLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 672 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "integerLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.INTEGER_LITERAL);
        this.addTokenNode(node, token);
    }

    public final void decimalLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 683 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "decimalLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.DECIMAL_LITERAL);
        this.addTokenNode(node, token);
    }

    public final void doubleLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 694 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "doubleLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.DOUBLE_LITERAL);
        this.addTokenNode(node, token);
    }

    public final void floatLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 705 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "floatLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.FLOAT_LITERAL);
        this.addTokenNode(node, token);
    }

    public final void stringLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 716 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "stringLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.STRING_LITERAL);
        this.addTokenNode(node, token);
    }

    public final void bytesLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 727 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "bytesLiteral";
        Token token = this.consumeToken(ExprLangConstants.TokenType.BYTES_LITERAL);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void literal(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 738 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "literal";
        this.clearExpectedItems();
        if (this.nextTokenType() == ExprLangConstants.TokenType.LONG_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 744, 5);
            try {
                this.longLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.INTEGER_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 745, 7);
            try {
                this.integerLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.DECIMAL_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 746, 7);
            try {
                this.decimalLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.DOUBLE_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 747, 7);
            try {
                this.doubleLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.FLOAT_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 748, 7);
            try {
                this.floatLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.STRING_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 749, 7);
            try {
                this.stringLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.BYTES_LITERAL) {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 750, 5);
            try {
                this.bytesLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("literal", "src\\main\\resources\\el.jj", 744, 5);
            throw new ParseException(this, first_set$el_jj$744$5, this.parsingStack);
        }
    }

    public final void nullLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 754 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "nullLiteral";
        this.pushOntoCallStack("nullLiteral", "src\\main\\resources\\el.jj", 758, 2);
        try {
            this.keyword(NULL);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(ELNodeType.NULL_LITERAL, NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void booleanLiteral(ELNode node) throws ParseException {
        Token bool;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 764 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "booleanLiteral";
        this.pushOntoCallStack("booleanLiteral", "src\\main\\resources\\el.jj", 769, 2);
        try {
            bool = this.keyword(TRUE, FALSE);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(ELNodeType.BOOLEAN_LITERAL, bool.getImage().toLowerCase());
    }

    public final Token keyword(String ... expected) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 776 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "keyword";
        Token token = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        String keyword = token.getImage();
        this.checkKeyword(token, expected);
        this.consumeKeyword(keyword);
        return token;
    }

    public final void identifier(ELNode node) throws ParseException {
        Token token;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 790 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "identifier";
        this.clearExpectedItems();
        if (this.nextTokenType() == ExprLangConstants.TokenType.VARIABLE) {
            token = this.consumeToken(ExprLangConstants.TokenType.VARIABLE);
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.HPATH) {
            token = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        } else {
            this.pushOntoCallStack("identifier", "src\\main\\resources\\el.jj", 796, 4);
            throw new ParseException(this, first_set$el_jj$796$4, this.parsingStack);
        }
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void argList(ELNode node) throws ParseException {
        Object newFollowSet;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 802 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "argList";
        this.pushOntoCallStack("argList", "src\\main\\resources\\el.jj", 806, 2);
        if (this.outerFollowSet != null) {
            newFollowSet = follow_set$el_jj$806$2.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.valueExpr(node);
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == ExprLangConstants.TokenType.COMMA) {
            this.consumeToken(ExprLangConstants.TokenType.COMMA);
            this.pushOntoCallStack("argList", "src\\main\\resources\\el.jj", 806, 28);
            if (this.outerFollowSet != null) {
                newFollowSet = follow_set$el_jj$806$28.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.valueExpr(node);
            }
            finally {
                this.popCallStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void functionCall(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 809 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "functionCall";
        Token token2 = null;
        ELNode args = new ELNode();
        this.clearExpectedItems();
        Token token1 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        if (this.nextTokenType() == ExprLangConstants.TokenType.COLON) {
            this.consumeToken(ExprLangConstants.TokenType.COLON);
            token2 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        }
        this.consumeToken(ExprLangConstants.TokenType.LEFT_PAREN);
        if (first_set$el_jj$818$64.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("functionCall", "src\\main\\resources\\el.jj", 818, 64);
            this.outerFollowSet = follow_set$el_jj$818$64$;
            try {
                this.argList(args);
            }
            finally {
                this.popCallStack();
            }
        }
        this.consumeToken(ExprLangConstants.TokenType.RIGHT_PAREN);
        if (token2 == null) {
            this.addFunctionCall(node, token1, args);
        } else if (this.isJavaCall(token1, token2)) {
            this.addJavaCall(node, token1, args);
        } else if (this.isJavaNew(token1, token2)) {
            this.addJavaNew(node, token1, args);
        } else {
            throw new ParseException(this.getErrorLocationMessage(token1, this.getMessage("invalidFunctionCall", token1.getImage() + ":" + token2.getImage())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void subExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 834 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "subExpr";
        ELNode temp = new ELNode();
        this.clearExpectedItems();
        this.consumeToken(ExprLangConstants.TokenType.LEFT_PAREN);
        this.pushOntoCallStack("subExpr", "src\\main\\resources\\el.jj", 840, 15);
        this.outerFollowSet = follow_set$el_jj$840$15;
        try {
            this.expr(temp);
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(ExprLangConstants.TokenType.RIGHT_PAREN);
        node.addBuildNode(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void array(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 846 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "array";
        ELNode array = new ELNode(ELNodeType.ARRAY, ARRAY);
        this.clearExpectedItems();
        Token leftSqBracketToken = this.consumeToken(ExprLangConstants.TokenType.LEFT_SQ_BRACKET);
        if (first_set$el_jj$853$40.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("array", "src\\main\\resources\\el.jj", 853, 40);
            this.outerFollowSet = follow_set$el_jj$853$40$;
            try {
                this.argList(array);
            }
            finally {
                this.popCallStack();
            }
        }
        this.consumeToken(ExprLangConstants.TokenType.RIGHT_SQ_BRACKET);
        this.setBeginLocation(array, leftSqBracketToken);
        node.addChild(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 860 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "atomExpr";
        this.expectingKeyword(true, NULL, TRUE, FALSE);
        if (first_set$el_jj$867$5.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 867, 5);
            try {
                this.literal(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(NULL)) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 868, 38);
            try {
                this.nullLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(TRUE, FALSE)) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 869, 45);
            try {
                this.booleanLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.scan$el_jj$870$5()) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 870, 18);
            try {
                this.functionCall(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.LEFT_SQ_BRACKET) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 871, 5);
            try {
                this.array(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.VARIABLE || this.nextTokenType == ExprLangConstants.TokenType.HPATH) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 872, 5);
            try {
                this.identifier(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.LEFT_PAREN) {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 873, 5);
            try {
                this.subExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("atomExpr", "src\\main\\resources\\el.jj", 867, 5);
            throw new ParseException(this, first_set$el_jj$867$5$, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notKeywordExpr(ELNode node) throws ParseException {
        Token notToken;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 877 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "notKeywordExpr";
        this.expectingKeyword(true, NOT_KEYWORD);
        ELNode notNode = new ELNode(ELNodeType.NOT, NOT_KEYWORD);
        this.pushOntoCallStack("notKeywordExpr", "src\\main\\resources\\el.jj", 884, 4);
        this.outerFollowSet = follow_set$el_jj$884$4;
        try {
            notToken = this.keyword(NOT_KEYWORD);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("notKeywordExpr", "src\\main\\resources\\el.jj", 884, 34);
        try {
            this.atomExpr(notNode);
        }
        finally {
            this.popCallStack();
        }
        this.setBeginLocation(notNode, notToken);
        node.addChild(notNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 890 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "notExpr";
        ELNode notNode = new ELNode(ELNodeType.NOT, this.getTokenImage(ExprLangConstants.TokenType.NOT));
        this.clearExpectedItems();
        Token notToken = this.consumeToken(ExprLangConstants.TokenType.NOT);
        this.pushOntoCallStack("notExpr", "src\\main\\resources\\el.jj", 897, 19);
        try {
            this.atomExpr(notNode);
        }
        finally {
            this.popCallStack();
        }
        this.setBeginLocation(notNode, notToken);
        node.addChild(notNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void singleExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 904 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "singleExpr";
        if (this.nextKeyword(NOT_KEYWORD)) {
            this.pushOntoCallStack("singleExpr", "src\\main\\resources\\el.jj", 909, 44);
            try {
                this.notKeywordExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (first_set$el_jj$910$6.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("singleExpr", "src\\main\\resources\\el.jj", 910, 6);
            try {
                this.atomExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.NOT) {
            this.pushOntoCallStack("singleExpr", "src\\main\\resources\\el.jj", 911, 6);
            try {
                this.notExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("singleExpr", "src\\main\\resources\\el.jj", 909, 4);
            throw new ParseException(this, first_set$el_jj$909$4, this.parsingStack);
        }
    }

    public final Token customOp(ELNode node, String opName, int position) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 915 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "customOp";
        Token customOpToken1 = null;
        Token customOpToken2 = null;
        Token customOpToken3 = null;
        this.expectingOperator(false, this.getParsingContext().getCustomOperator(opName, position));
        if (this.checkNbrOfCustomOpToken(opName, position, 1)) {
            customOpToken1 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        } else if (this.checkNbrOfCustomOpToken(opName, position, 2)) {
            customOpToken1 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
            customOpToken2 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        } else if (this.checkNbrOfCustomOpToken(opName, position, 3)) {
            customOpToken1 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
            customOpToken2 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
            customOpToken3 = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        } else {
            this.pushOntoCallStack("customOp", "src\\main\\resources\\el.jj", 924, 5);
            throw new ParseException(this, first_set$el_jj$924$5, this.parsingStack);
        }
        this.checkCustomOp(opName, position, customOpToken1, customOpToken2, customOpToken3);
        this.addCustomOpNode(node, customOpToken1, customOpToken2, customOpToken3);
        this.consumeOperator();
        return customOpToken1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token unaryOrBinaryOrTernaryOp(ELNode node, String opName) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 936 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "unaryOrBinaryOrTernaryOp";
        Token opToken = null;
        if (this.nextIsTernaryOp(opName)) {
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 44);
            this.outerFollowSet = follow_set$el_jj$942$44;
            try {
                opToken = this.customOp(node, opName, 0);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 78);
            this.outerFollowSet = follow_set$el_jj$942$78;
            try {
                this.singleExpr(node);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 95);
            this.outerFollowSet = follow_set$el_jj$942$95;
            try {
                this.customOp(node, opName, 1);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 121);
            try {
                this.singleExpr(node);
            }
            finally {
                this.popCallStack();
            }
        }
        if (this.nextIsBinaryOp(opName)) {
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 943, 43);
            this.outerFollowSet = follow_set$el_jj$943$43;
            try {
                opToken = this.customOp(node, opName, 0);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 943, 77);
            try {
                this.singleExpr(node);
            }
            finally {
                this.popCallStack();
            }
        }
        if (this.nextIsUnaryOp(opName)) {
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 944, 42);
            try {
                opToken = this.customOp(node, opName, 0);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 5);
            throw new ParseException(this, first_set$el_jj$942$5, this.parsingStack);
        }
        return opToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token naryOp(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 951 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "naryOp";
        String opName = this.getNextCustomOpName();
        Token opToken = null;
        if (this.nextIsCustomOp(opName)) {
            this.pushOntoCallStack("naryOp", "src\\main\\resources\\el.jj", 957, 42);
            try {
                opToken = this.unaryOrBinaryOrTernaryOp(node, opName);
            }
            finally {
                this.popCallStack();
            }
        }
        return opToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void customOpExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 963 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "customOpExpr";
        ELNode opNode = new ELNode();
        Token opToken = null;
        this.pushOntoCallStack("customOpExpr", "src\\main\\resources\\el.jj", 970, 3);
        if (this.outerFollowSet != null) {
            Object newFollowSet = follow_set$el_jj$970$3.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.singleExpr(opNode);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("customOpExpr", "src\\main\\resources\\el.jj", 970, 22);
        try {
            opToken = this.naryOp(opNode);
        }
        finally {
            this.popCallStack();
        }
        if (opNode.getChildren().size() == 1) {
            node.addBuildNode(opNode);
        } else {
            this.convertCustomOpToFunctionCall(node, opNode, opToken);
        }
    }

    public final void multiply(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 981 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "multiply";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.STAR);
        this.addTokenNode(node, token);
    }

    public final void divide(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 992 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "divide";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.SLASH);
        this.addTokenNode(node, token);
    }

    public final void modulo(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1003 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "modulo";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.MOD);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void multOp(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1014 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "multOp";
        if (this.nextTokenType() == ExprLangConstants.TokenType.STAR) {
            this.pushOntoCallStack("multOp", "src\\main\\resources\\el.jj", 1018, 2);
            try {
                this.multiply(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.SLASH) {
            this.pushOntoCallStack("multOp", "src\\main\\resources\\el.jj", 1018, 19);
            try {
                this.divide(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.MOD) {
            this.pushOntoCallStack("multOp", "src\\main\\resources\\el.jj", 1018, 34);
            try {
                this.modulo(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("multOp", "src\\main\\resources\\el.jj", 1018, 2);
            throw new ParseException(this, multOp_FIRST_SET, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void multExpr(ELNode node) throws ParseException {
        Object newFollowSet;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1021 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "multExpr";
        ELNode multNode = new ELNode();
        this.pushOntoCallStack("multExpr", "src\\main\\resources\\el.jj", 1026, 4);
        if (this.outerFollowSet != null) {
            newFollowSet = follow_set$el_jj$1026$4.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.customOpExpr(multNode);
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == ExprLangConstants.TokenType.SLASH || this.nextTokenType == ExprLangConstants.TokenType.STAR || this.nextTokenType == ExprLangConstants.TokenType.MOD) {
            this.pushOntoCallStack("multExpr", "src\\main\\resources\\el.jj", 1026, 29);
            this.outerFollowSet = follow_set$el_jj$1026$29;
            try {
                this.multOp(multNode);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("multExpr", "src\\main\\resources\\el.jj", 1026, 46);
            if (this.outerFollowSet != null) {
                newFollowSet = follow_set$el_jj$1026$46.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.customOpExpr(multNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (multNode.hasSingleChild()) {
            node.addBuildNode(multNode);
        } else {
            node.addBinaryOperandNode(multNode);
        }
    }

    public final void add(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1036 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "add";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.PLUS);
        this.addTokenNode(node, token);
    }

    public final void substract(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1047 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "substract";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.MINUS);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOp(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1058 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "addOp";
        if (this.nextTokenType() == ExprLangConstants.TokenType.PLUS) {
            this.pushOntoCallStack("addOp", "src\\main\\resources\\el.jj", 1062, 2);
            try {
                this.add(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.MINUS) {
            this.pushOntoCallStack("addOp", "src\\main\\resources\\el.jj", 1062, 14);
            try {
                this.substract(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("addOp", "src\\main\\resources\\el.jj", 1062, 2);
            throw new ParseException(this, addOp_FIRST_SET, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExpr(ELNode node) throws ParseException {
        Object newFollowSet;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1065 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "addExpr";
        ELNode addNode = new ELNode();
        this.pushOntoCallStack("addExpr", "src\\main\\resources\\el.jj", 1070, 4);
        if (this.outerFollowSet != null) {
            newFollowSet = follow_set$el_jj$1070$4.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.multExpr(addNode);
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == ExprLangConstants.TokenType.MINUS || this.nextTokenType == ExprLangConstants.TokenType.PLUS) {
            this.pushOntoCallStack("addExpr", "src\\main\\resources\\el.jj", 1070, 24);
            this.outerFollowSet = follow_set$el_jj$1070$24;
            try {
                this.addOp(addNode);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("addExpr", "src\\main\\resources\\el.jj", 1070, 39);
            if (this.outerFollowSet != null) {
                newFollowSet = follow_set$el_jj$1070$39.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.multExpr(addNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (addNode.hasSingleChild()) {
            node.addBuildNode(addNode);
        } else {
            node.addBinaryOperandNode(addNode);
        }
    }

    public final void equal(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1080 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "equal";
        Token token = null;
        if (this.nextTokenType() == ExprLangConstants.TokenType.EQ_1) {
            token = this.consumeToken(ExprLangConstants.TokenType.EQ_1);
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.EQ_2) {
            token = this.consumeToken(ExprLangConstants.TokenType.EQ_2);
        } else {
            this.pushOntoCallStack("equal", "src\\main\\resources\\el.jj", 1085, 4);
            throw new ParseException(this, first_set$el_jj$1085$4, this.parsingStack);
        }
        this.addTokenNode(node, token, "==");
    }

    public final void notEqual(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1091 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "notEqual";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.NE);
        this.addTokenNode(node, token);
    }

    public final void lowerThan(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1102 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "lowerThan";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.LT);
        this.addTokenNode(node, token);
    }

    public final void lowerThanOrEqual(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1113 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "lowerThanOrEqual";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.LE);
        this.addTokenNode(node, token);
    }

    public final void greaterThan(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1124 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "greaterThan";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.GT);
        this.addTokenNode(node, token);
    }

    public final void greaterThanOrEqual(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1135 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "greaterThanOrEqual";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.GE);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compOp(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1146 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "compOp";
        if (this.nextTokenType() == ExprLangConstants.TokenType.EQ_1 || this.nextTokenType == ExprLangConstants.TokenType.EQ_2) {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1151, 5);
            try {
                this.equal(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.NE) {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1152, 5);
            try {
                this.notEqual(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.LT) {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1153, 5);
            try {
                this.lowerThan(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.LE) {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1154, 5);
            try {
                this.lowerThanOrEqual(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.GT) {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1155, 5);
            try {
                this.greaterThan(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.GE) {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1156, 5);
            try {
                this.greaterThanOrEqual(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("compOp", "src\\main\\resources\\el.jj", 1151, 5);
            throw new ParseException(this, first_set$el_jj$1151$5, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1160 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "compExpr";
        ELNode compNode = new ELNode();
        this.pushOntoCallStack("compExpr", "src\\main\\resources\\el.jj", 1165, 4);
        if (this.outerFollowSet != null) {
            Object newFollowSet = follow_set$el_jj$1165$4.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.addExpr(compNode);
        }
        finally {
            this.popCallStack();
        }
        if (first_set$el_jj$1165$24.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("compExpr", "src\\main\\resources\\el.jj", 1165, 24);
            this.outerFollowSet = follow_set$el_jj$1165$24$;
            try {
                this.compOp(compNode);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("compExpr", "src\\main\\resources\\el.jj", 1165, 41);
            try {
                this.addExpr(compNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (compNode.hasSingleChild()) {
            node.addBuildNode(compNode);
        } else {
            node.addBinaryOperandNode(compNode);
        }
    }

    public final void and(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1175 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "and";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.AND);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void andExpr(ELNode node) throws ParseException {
        Object newFollowSet;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1186 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "andExpr";
        ELNode logicalNode = new ELNode();
        this.pushOntoCallStack("andExpr", "src\\main\\resources\\el.jj", 1191, 4);
        if (this.outerFollowSet != null) {
            newFollowSet = follow_set$el_jj$1191$4.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.compExpr(logicalNode);
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == ExprLangConstants.TokenType.AND) {
            this.pushOntoCallStack("andExpr", "src\\main\\resources\\el.jj", 1191, 28);
            this.outerFollowSet = follow_set$el_jj$1191$28;
            try {
                this.and(logicalNode);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("andExpr", "src\\main\\resources\\el.jj", 1191, 45);
            if (this.outerFollowSet != null) {
                newFollowSet = follow_set$el_jj$1191$45.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.compExpr(logicalNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (logicalNode.hasSingleChild()) {
            node.addBuildNode(logicalNode);
        } else {
            node.addMultiOperandNode(logicalNode);
        }
    }

    public final void or(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1201 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "or";
        Token token = null;
        token = this.consumeToken(ExprLangConstants.TokenType.OR);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void orExpr(ELNode node) throws ParseException {
        Object newFollowSet;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1212 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "orExpr";
        ELNode logicalNode = new ELNode();
        this.pushOntoCallStack("orExpr", "src\\main\\resources\\el.jj", 1217, 4);
        if (this.outerFollowSet != null) {
            newFollowSet = follow_set$el_jj$1217$4.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.andExpr(logicalNode);
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == ExprLangConstants.TokenType.OR) {
            this.pushOntoCallStack("orExpr", "src\\main\\resources\\el.jj", 1217, 27);
            this.outerFollowSet = follow_set$el_jj$1217$27;
            try {
                this.or(logicalNode);
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("orExpr", "src\\main\\resources\\el.jj", 1217, 43);
            if (this.outerFollowSet != null) {
                newFollowSet = follow_set$el_jj$1217$43.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.andExpr(logicalNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (logicalNode.hasSingleChild()) {
            node.addBuildNode(logicalNode);
        } else {
            node.addMultiOperandNode(logicalNode);
        }
    }

    public final void valueExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1227 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "valueExpr";
        this.clearExpectedItems();
        this.pushOntoCallStack("valueExpr", "src\\main\\resources\\el.jj", 1232, 2);
        try {
            this.orExpr(node);
        }
        finally {
            this.popCallStack();
        }
    }

    public final void expr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1235 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "expr";
        this.pushOntoCallStack("expr", "src\\main\\resources\\el.jj", 1239, 2);
        try {
            this.valueExpr(node);
        }
        finally {
            this.popCallStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void condition(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1242 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "condition";
        ELNode condNode = new ELNode(ELNodeType.CONDITION, IF);
        this.pushOntoCallStack("condition", "src\\main\\resources\\el.jj", 1247, 2);
        try {
            this.valueExpr(condNode);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(condNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void thenExprBlock(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1253 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "thenExprBlock";
        ELNode thenNode = new ELNode(ELNodeType.THEN, THEN);
        if (first_set$el_jj$1258$4.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("thenExprBlock", "src\\main\\resources\\el.jj", 1258, 4);
            try {
                this.valueExpr(thenNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (this.nextTokenType() == ExprLangConstants.TokenType.LEFT_CURLY_BRACKET) {
            this.consumeToken(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET);
            this.pushOntoCallStack("thenExprBlock", "src\\main\\resources\\el.jj", 1258, 47);
            this.outerFollowSet = follow_set$el_jj$1258$47;
            try {
                this.block(thenNode);
            }
            finally {
                this.popCallStack();
            }
            this.consumeToken(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET);
        } else {
            this.pushOntoCallStack("thenExprBlock", "src\\main\\resources\\el.jj", 1258, 4);
            throw new ParseException(this, first_set$el_jj$1258$4$, this.parsingStack);
        }
        node.addChild(thenNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void elseExprBlock(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1264 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "elseExprBlock";
        ELNode elseNode = new ELNode(ELNodeType.ELSE, ELSE);
        if (first_set$el_jj$1269$4.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("elseExprBlock", "src\\main\\resources\\el.jj", 1269, 4);
            try {
                this.valueExpr(elseNode);
            }
            finally {
                this.popCallStack();
            }
        }
        if (this.nextTokenType() == ExprLangConstants.TokenType.LEFT_CURLY_BRACKET) {
            this.consumeToken(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET);
            this.pushOntoCallStack("elseExprBlock", "src\\main\\resources\\el.jj", 1269, 47);
            this.outerFollowSet = follow_set$el_jj$1269$47;
            try {
                this.block(elseNode);
            }
            finally {
                this.popCallStack();
            }
            this.consumeToken(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET);
        } else {
            this.pushOntoCallStack("elseExprBlock", "src\\main\\resources\\el.jj", 1269, 4);
            throw new ParseException(this, first_set$el_jj$1269$4$, this.parsingStack);
        }
        node.addChild(elseNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void elseifExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1275 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "elseifExpr";
        this.expectingKeyword(false, ELSEIF);
        this.pushOntoCallStack("elseifExpr", "src\\main\\resources\\el.jj", 1280, 2);
        this.outerFollowSet = follow_set$el_jj$1280$2;
        try {
            this.keyword(ELSEIF);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("elseifExpr", "src\\main\\resources\\el.jj", 1280, 18);
        this.outerFollowSet = follow_set$el_jj$1280$18;
        try {
            this.condition(node);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("elseifExpr", "src\\main\\resources\\el.jj", 1280, 34);
        try {
            this.thenExprBlock(node);
        }
        finally {
            this.popCallStack();
        }
    }

    public final void elseifOptionalExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1283 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "elseifOptionalExpr";
        this.expectingKeyword(true, ELSEIF, ELSE);
        this.pushOntoCallStack("elseifOptionalExpr", "src\\main\\resources\\el.jj", 1288, 37);
        try {
            this.elseifExpr(node);
        }
        finally {
            this.popCallStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void elseExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1291 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "elseExpr";
        this.expectingKeyword(false, ELSE);
        this.pushOntoCallStack("elseExpr", "src\\main\\resources\\el.jj", 1296, 2);
        this.outerFollowSet = follow_set$el_jj$1296$2;
        try {
            this.keyword(ELSE);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("elseExpr", "src\\main\\resources\\el.jj", 1296, 16);
        try {
            this.elseExprBlock(node);
        }
        finally {
            this.popCallStack();
        }
    }

    public final void elseOptionalExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1299 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "elseOptionalExpr";
        this.expectingKeyword(true, ELSEIF, ELSE);
        this.pushOntoCallStack("elseOptionalExpr", "src\\main\\resources\\el.jj", 1304, 35);
        try {
            this.elseExpr(node);
        }
        finally {
            this.popCallStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void elseOrElseifExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1307 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "elseOrElseifExpr";
        this.expectingKeyword(true, ELSEIF, ELSE);
        while (this.nextKeyword(ELSEIF)) {
            this.pushOntoCallStack("elseOrElseifExpr", "src\\main\\resources\\el.jj", 1312, 4);
            if (this.outerFollowSet != null) {
                Object newFollowSet = follow_set$el_jj$1312$4.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.elseifOptionalExpr(node);
            }
            finally {
                this.popCallStack();
            }
        }
        if (this.nextKeyword(ELSE)) {
            this.pushOntoCallStack("elseOrElseifExpr", "src\\main\\resources\\el.jj", 1312, 34);
            try {
                this.elseOptionalExpr(node);
            }
            finally {
                this.popCallStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void thenElseExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1315 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "thenElseExpr";
        this.pushOntoCallStack("thenElseExpr", "src\\main\\resources\\el.jj", 1319, 2);
        if (this.outerFollowSet != null) {
            Object newFollowSet = follow_set$el_jj$1319$2.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.thenExprBlock(node);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("thenElseExpr", "src\\main\\resources\\el.jj", 1319, 22);
        try {
            this.elseOrElseifExpr(node);
        }
        finally {
            this.popCallStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ifExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1322 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ifExpr";
        ELNode ifThenElseNode = new ELNode(ELNodeType.IF_THEN_ELSE, IF_THEN_ELSE);
        this.pushOntoCallStack("ifExpr", "src\\main\\resources\\el.jj", 1328, 3);
        this.outerFollowSet = follow_set$el_jj$1328$3;
        try {
            this.keyword(IF);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("ifExpr", "src\\main\\resources\\el.jj", 1328, 15);
        this.outerFollowSet = follow_set$el_jj$1328$15;
        try {
            this.condition(ifThenElseNode);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("ifExpr", "src\\main\\resources\\el.jj", 1328, 41);
        try {
            this.thenElseExpr(ifThenElseNode);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(ifThenElseNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void caseLiteral(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1335 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "caseLiteral";
        this.expectingKeyword(true, TRUE, FALSE);
        if (first_set$el_jj$1341$7.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("caseLiteral", "src\\main\\resources\\el.jj", 1341, 7);
            try {
                this.literal(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(TRUE, FALSE)) {
            this.pushOntoCallStack("caseLiteral", "src\\main\\resources\\el.jj", 1342, 45);
            try {
                this.booleanLiteral(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("caseLiteral", "src\\main\\resources\\el.jj", 1341, 7);
            throw new ParseException(this, first_set$el_jj$1341$7$, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void caseClause(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1346 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "caseClause";
        ELNode caseNode = new ELNode(ELNodeType.CASE, CASE);
        this.pushOntoCallStack("caseClause", "src\\main\\resources\\el.jj", 1351, 4);
        this.outerFollowSet = follow_set$el_jj$1351$4;
        try {
            this.keyword(CASE);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("caseClause", "src\\main\\resources\\el.jj", 1351, 18);
        this.outerFollowSet = follow_set$el_jj$1351$18;
        try {
            this.caseLiteral(caseNode);
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(ExprLangConstants.TokenType.COLON);
        this.pushOntoCallStack("caseClause", "src\\main\\resources\\el.jj", 1351, 48);
        try {
            this.block(caseNode);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(caseNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void defaultClause(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1357 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "defaultClause";
        ELNode defaultNode = new ELNode(ELNodeType.DEFAULT, DEFAULT);
        this.pushOntoCallStack("defaultClause", "src\\main\\resources\\el.jj", 1362, 4);
        this.outerFollowSet = follow_set$el_jj$1362$4;
        try {
            this.keyword(DEFAULT);
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(ExprLangConstants.TokenType.COLON);
        this.pushOntoCallStack("defaultClause", "src\\main\\resources\\el.jj", 1362, 29);
        try {
            this.block(defaultNode);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(defaultNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void caseOrDefaultClause(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1368 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "caseOrDefaultClause";
        this.expectingKeyword(false, CASE, DEFAULT);
        if (this.nextKeyword(CASE)) {
            this.pushOntoCallStack("caseOrDefaultClause", "src\\main\\resources\\el.jj", 1374, 38);
            try {
                this.caseClause(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(DEFAULT)) {
            this.pushOntoCallStack("caseOrDefaultClause", "src\\main\\resources\\el.jj", 1375, 41);
            try {
                this.defaultClause(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("caseOrDefaultClause", "src\\main\\resources\\el.jj", 1374, 5);
            throw new ParseException(this, first_set$el_jj$1374$5, this.parsingStack);
        }
    }

    public final void caseOrDefaultClauses(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1379 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "caseOrDefaultClauses";
        this.consumeToken(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET);
        do {
            this.pushOntoCallStack("caseOrDefaultClauses", "src\\main\\resources\\el.jj", 1385, 3);
            this.outerFollowSet = follow_set$el_jj$1385$3;
            try {
                this.caseOrDefaultClause(node);
            }
            finally {
                this.popCallStack();
            }
        } while (this.nextTokenType() == ExprLangConstants.TokenType.HPATH);
        this.consumeToken(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void switchExpr(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1390 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "switchExpr";
        ELNode switchNode = new ELNode(ELNodeType.SWITCH, SWITCH);
        this.pushOntoCallStack("switchExpr", "src\\main\\resources\\el.jj", 1396, 3);
        this.outerFollowSet = follow_set$el_jj$1396$3;
        try {
            this.keyword(SWITCH);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("switchExpr", "src\\main\\resources\\el.jj", 1396, 19);
        this.outerFollowSet = follow_set$el_jj$1396$19;
        try {
            this.condition(switchNode);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("switchExpr", "src\\main\\resources\\el.jj", 1396, 41);
        try {
            this.caseOrDefaultClauses(switchNode);
        }
        finally {
            this.popCallStack();
        }
        node.addChild(switchNode);
    }

    public final Token assign() throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1403 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "assign";
        Token token = this.consumeToken(ExprLangConstants.TokenType.EQ_1);
        return token;
    }

    public final void assignmentTargetIdentifier(ELNode node) throws ParseException {
        Token token;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1414 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "assignmentTargetIdentifier";
        this.clearExpectedItems();
        if (this.nextTokenType() == ExprLangConstants.TokenType.VARIABLE) {
            token = this.consumeToken(ExprLangConstants.TokenType.VARIABLE);
        } else if (this.nextTokenType() == ExprLangConstants.TokenType.HPATH) {
            token = this.consumeToken(ExprLangConstants.TokenType.HPATH);
        } else {
            this.pushOntoCallStack("assignmentTargetIdentifier", "src\\main\\resources\\el.jj", 1420, 4);
            throw new ParseException(this, first_set$el_jj$1420$4, this.parsingStack);
        }
        this.checkNotKeyword(token);
        this.addTokenNode(node, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assignmentLetExpr(ELNode node) throws ParseException {
        Token assignToken;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1427 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "assignmentLetExpr";
        ELNode tempNode = new ELNode();
        this.pushOntoCallStack("assignmentLetExpr", "src\\main\\resources\\el.jj", 1434, 3);
        this.outerFollowSet = follow_set$el_jj$1434$3;
        try {
            this.keyword(LET);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("assignmentLetExpr", "src\\main\\resources\\el.jj", 1434, 16);
        this.outerFollowSet = follow_set$el_jj$1434$16;
        try {
            this.assignmentTargetIdentifier(tempNode);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("assignmentLetExpr", "src\\main\\resources\\el.jj", 1434, 53);
        this.outerFollowSet = follow_set$el_jj$1434$53;
        try {
            assignToken = this.assign();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("assignmentLetExpr", "src\\main\\resources\\el.jj", 1434, 74);
        try {
            this.assignmentExprContent(tempNode);
        }
        finally {
            this.popCallStack();
        }
        ELNode assignNode = new ELNode(ELNodeType.ASSIGN, assignToken.getImage());
        assignNode.addChildren(tempNode.getChildren());
        node.addChild(assignNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assignmentExpr(ELNode node) throws ParseException {
        Token assignToken;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1443 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "assignmentExpr";
        ELNode tempNode = new ELNode();
        this.pushOntoCallStack("assignmentExpr", "src\\main\\resources\\el.jj", 1450, 3);
        this.outerFollowSet = follow_set$el_jj$1450$3;
        try {
            this.assignmentTargetIdentifier(tempNode);
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("assignmentExpr", "src\\main\\resources\\el.jj", 1450, 40);
        this.outerFollowSet = follow_set$el_jj$1450$40;
        try {
            assignToken = this.assign();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("assignmentExpr", "src\\main\\resources\\el.jj", 1450, 61);
        try {
            this.assignmentExprContent(tempNode);
        }
        finally {
            this.popCallStack();
        }
        ELNode assignNode = new ELNode(ELNodeType.ASSIGN, assignToken.getImage());
        assignNode.addChildren(tempNode.getChildren());
        node.addChild(assignNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assignmentExprContent(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1459 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "assignmentExprContent";
        this.expectingKeyword(true, SWITCH, IF);
        if (this.nextKeyword(SWITCH)) {
            this.pushOntoCallStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1465, 41);
            try {
                this.switchExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(IF)) {
            this.pushOntoCallStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1466, 37);
            try {
                this.ifExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.scan$el_jj$1467$6()) {
            this.pushOntoCallStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1467, 19);
            try {
                this.valueExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1465, 6);
            throw new ParseException(this, first_set$el_jj$1465$6, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void statement(ELNode node) throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1471 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "statement";
        this.expectingKeyword(true, SWITCH, IF, LET);
        if (this.nextKeyword(SWITCH)) {
            this.pushOntoCallStack("statement", "src\\main\\resources\\el.jj", 1477, 40);
            try {
                this.switchExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(IF)) {
            this.pushOntoCallStack("statement", "src\\main\\resources\\el.jj", 1478, 36);
            try {
                this.ifExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextKeyword(LET)) {
            this.pushOntoCallStack("statement", "src\\main\\resources\\el.jj", 1479, 37);
            try {
                this.assignmentLetExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.scan$el_jj$1480$5()) {
            this.pushOntoCallStack("statement", "src\\main\\resources\\el.jj", 1480, 18);
            try {
                this.assignmentExpr(node);
            }
            finally {
                this.popCallStack();
            }
        } else if (first_set$el_jj$1481$5.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("statement", "src\\main\\resources\\el.jj", 1481, 5);
            try {
                this.expr(node);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("statement", "src\\main\\resources\\el.jj", 1477, 5);
            throw new ParseException(this, first_set$el_jj$1477$5, this.parsingStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void block(ELNode node) throws ParseException {
        Object newFollowSet;
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1485 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "block";
        ELNode blockNode = new ELNode(ELNodeType.EXPR_BLOCK);
        this.pushOntoCallStack("block", "src\\main\\resources\\el.jj", 1490, 4);
        if (this.outerFollowSet != null) {
            newFollowSet = follow_set$el_jj$1490$4.clone();
            ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
            this.outerFollowSet = newFollowSet;
        }
        try {
            this.statement(blockNode);
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == ExprLangConstants.TokenType.COMMA || this.nextTokenType == ExprLangConstants.TokenType.SEMICOLON) {
            if (this.nextTokenType() == ExprLangConstants.TokenType.SEMICOLON) {
                this.consumeToken(ExprLangConstants.TokenType.SEMICOLON);
            } else if (this.nextTokenType() == ExprLangConstants.TokenType.COMMA) {
                this.consumeToken(ExprLangConstants.TokenType.COMMA);
            } else {
                this.pushOntoCallStack("block", "src\\main\\resources\\el.jj", 1490, 29);
                throw new ParseException(this, first_set$el_jj$1490$29, this.parsingStack);
            }
            this.pushOntoCallStack("block", "src\\main\\resources\\el.jj", 1490, 53);
            if (this.outerFollowSet != null) {
                newFollowSet = follow_set$el_jj$1490$53.clone();
                ((AbstractCollection)newFollowSet).addAll(this.outerFollowSet);
                this.outerFollowSet = newFollowSet;
            }
            try {
                this.statement(blockNode);
            }
            finally {
                this.popCallStack();
            }
        }
        node.addChild(blockNode);
    }

    public final ELNode parse() throws ParseException {
        if (this.trace_enabled) {
            LOGGER.info("Entering production defined on line 1496 of src\\main\\resources\\el.jj");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "parse";
        ELNode root = new ELNode(this.dslContent);
        this.pushOntoCallStack("parse", "src\\main\\resources\\el.jj", 1501, 2);
        this.outerFollowSet = follow_set$el_jj$1501$2;
        try {
            this.block(root);
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(ExprLangConstants.TokenType.EOF);
        return root;
    }

    private final boolean scanToken(ExprLangConstants.TokenType expectedType) {
        this.currentLookaheadToken = this.nextToken(this.currentLookaheadToken);
        ExprLangConstants.TokenType type = this.currentLookaheadToken.getType();
        if (type != expectedType) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.remainingLookahead != Integer.MAX_VALUE) {
            --this.remainingLookahead;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean scanToken(EnumSet<ExprLangConstants.TokenType> types) {
        this.currentLookaheadToken = this.nextToken(this.currentLookaheadToken);
        ExprLangConstants.TokenType type = this.currentLookaheadToken.getType();
        if (!types.contains((Object)type)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.remainingLookahead != Integer.MAX_VALUE) {
            --this.remainingLookahead;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$806$20() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.COMMA)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("argList", "src\\main\\resources\\el.jj", 806, 28);
            String prevProduction1267 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "valueExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$valueExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1267;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    private final boolean check$el_jj$818$22() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.COLON)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$818$64() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("functionCall", "src\\main\\resources\\el.jj", 818, 64);
            String prevProduction1271 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "argList";
            this.scanToEnd = false;
            try {
                if (!this.check$argList()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1271;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$853$40() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("array", "src\\main\\resources\\el.jj", 853, 40);
            String prevProduction1272 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "argList";
            this.scanToEnd = false;
            try {
                if (!this.check$argList()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1272;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$870$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("atomExpr", "src\\main\\resources\\el.jj", 870, 18);
            String prevProduction1273 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "functionCall";
            this.scanToEnd = true;
            try {
                if (!this.check$functionCall()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1273;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$871$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("atomExpr", "src\\main\\resources\\el.jj", 871, 5);
            String prevProduction1274 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "array";
            this.scanToEnd = false;
            try {
                if (!this.check$array()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1274;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$873$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("atomExpr", "src\\main\\resources\\el.jj", 873, 5);
            String prevProduction1275 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "subExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$subExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1275;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$909$4() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("singleExpr", "src\\main\\resources\\el.jj", 909, 44);
            String prevProduction1278 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "notKeywordExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$notKeywordExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1278;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$910$6() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("singleExpr", "src\\main\\resources\\el.jj", 910, 6);
            String prevProduction1279 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "atomExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$atomExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1279;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$911$6() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("singleExpr", "src\\main\\resources\\el.jj", 911, 6);
            String prevProduction1280 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "notExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$notExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1280;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    private final boolean check$el_jj$925$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    private final boolean check$el_jj$926$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$942$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 44);
            String prevProduction1281 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "customOp";
            this.scanToEnd = false;
            try {
                if (!this.check$customOp()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1281;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 78);
            String prevProduction1282 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "singleExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$singleExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1282;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 95);
            String prevProduction1283 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "customOp";
            this.scanToEnd = true;
            try {
                if (!this.check$customOp()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1283;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 942, 121);
            String prevProduction1284 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "singleExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$singleExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1284;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$943$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 943, 43);
            String prevProduction1285 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "customOp";
            this.scanToEnd = false;
            try {
                if (!this.check$customOp()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1285;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 943, 77);
            String prevProduction1286 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "singleExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$singleExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1286;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$944$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("unaryOrBinaryOrTernaryOp", "src\\main\\resources\\el.jj", 944, 42);
            String prevProduction1287 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "customOp";
            this.scanToEnd = false;
            try {
                if (!this.check$customOp()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1287;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$957$4() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("naryOp", "src\\main\\resources\\el.jj", 957, 42);
            String prevProduction1288 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "unaryOrBinaryOrTernaryOp";
            this.scanToEnd = false;
            try {
                if (!this.check$unaryOrBinaryOrTernaryOp()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1288;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1026$29() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(first_set$el_jj$1026$29)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("multExpr", "src\\main\\resources\\el.jj", 1026, 46);
            String prevProduction1293 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "customOpExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$customOpExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1293;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1070$24() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(first_set$el_jj$1070$24)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("addExpr", "src\\main\\resources\\el.jj", 1070, 39);
            String prevProduction1296 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "multExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$multExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1296;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1165$24() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(first_set$el_jj$1165$24$)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("compExpr", "src\\main\\resources\\el.jj", 1165, 41);
            String prevProduction1299 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "addExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$addExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1299;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1191$28() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.AND)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("andExpr", "src\\main\\resources\\el.jj", 1191, 45);
            String prevProduction1302 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "compExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$compExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1302;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1217$27() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.OR)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("orExpr", "src\\main\\resources\\el.jj", 1217, 43);
            String prevProduction1305 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "andExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$andExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1305;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1258$4() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("thenExprBlock", "src\\main\\resources\\el.jj", 1258, 4);
            String prevProduction1306 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "valueExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$valueExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1306;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1258$26() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("thenExprBlock", "src\\main\\resources\\el.jj", 1258, 47);
            String prevProduction1307 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "block";
            this.scanToEnd = true;
            try {
                if (!this.check$block()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1307;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1269$4() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("elseExprBlock", "src\\main\\resources\\el.jj", 1269, 4);
            String prevProduction1308 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "valueExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$valueExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1308;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1269$26() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("elseExprBlock", "src\\main\\resources\\el.jj", 1269, 47);
            String prevProduction1309 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "block";
            this.scanToEnd = true;
            try {
                if (!this.check$block()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1309;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1312$4() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("elseOrElseifExpr", "src\\main\\resources\\el.jj", 1312, 4);
            String prevProduction1310 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "elseifOptionalExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$elseifOptionalExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1310;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1312$34() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("elseOrElseifExpr", "src\\main\\resources\\el.jj", 1312, 34);
            String prevProduction1311 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "elseOptionalExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$elseOptionalExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1311;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1374$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("caseOrDefaultClause", "src\\main\\resources\\el.jj", 1374, 38);
            String prevProduction1316 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "caseClause";
            this.scanToEnd = false;
            try {
                if (!this.check$caseClause()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1316;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1375$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("caseOrDefaultClause", "src\\main\\resources\\el.jj", 1375, 41);
            String prevProduction1317 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "defaultClause";
            this.scanToEnd = false;
            try {
                if (!this.check$defaultClause()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1317;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1385$3() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("caseOrDefaultClauses", "src\\main\\resources\\el.jj", 1385, 3);
            String prevProduction1318 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "caseOrDefaultClause";
            this.scanToEnd = false;
            try {
                if (!this.check$caseOrDefaultClause()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1318;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1465$6() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1465, 41);
            String prevProduction1323 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "switchExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$switchExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1323;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1466$6() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1466, 37);
            String prevProduction1324 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "ifExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$ifExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1324;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1467$6() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1467, 19);
            String prevProduction1325 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "valueExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$valueExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1325;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1477$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("statement", "src\\main\\resources\\el.jj", 1477, 40);
            String prevProduction1326 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "switchExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$switchExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1326;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1478$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("statement", "src\\main\\resources\\el.jj", 1478, 36);
            String prevProduction1327 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "ifExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$ifExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1327;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1479$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("statement", "src\\main\\resources\\el.jj", 1479, 37);
            String prevProduction1328 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "assignmentLetExpr";
            this.scanToEnd = false;
            try {
                if (!this.check$assignmentLetExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1328;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1480$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("statement", "src\\main\\resources\\el.jj", 1480, 18);
            String prevProduction1329 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "assignmentExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$assignmentExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1329;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1481$5() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("statement", "src\\main\\resources\\el.jj", 1481, 5);
            String prevProduction1330 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "expr";
            this.scanToEnd = false;
            try {
                if (!this.check$expr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1330;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$el_jj$1490$27() {
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            if (!this.scanToken(first_set$el_jj$1490$29)) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("block", "src\\main\\resources\\el.jj", 1490, 53);
            String prevProduction1333 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "statement";
            this.scanToEnd = true;
            try {
                if (!this.check$statement()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1333;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$el_jj$870$5() {
        try {
            ++this.lookaheadRoutineNesting;
            this.currentLookaheadToken = this.lastConsumedToken;
            this.remainingLookahead = 2;
            this.hitFailure = false;
            this.scanToEnd = true;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("atomExpr", "src\\main\\resources\\el.jj", 870, 18);
            String prevProduction1334 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "functionCall";
            this.scanToEnd = true;
            try {
                if (!this.check$functionCall()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1334;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
            this.currentLookaheadToken = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$el_jj$1467$6() {
        try {
            ++this.lookaheadRoutineNesting;
            this.currentLookaheadToken = this.lastConsumedToken;
            this.remainingLookahead = 3;
            this.hitFailure = false;
            this.scanToEnd = true;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("assignmentExprContent", "src\\main\\resources\\el.jj", 1467, 19);
            String prevProduction1335 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "valueExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$valueExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1335;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
            this.currentLookaheadToken = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$el_jj$1480$5() {
        try {
            ++this.lookaheadRoutineNesting;
            this.currentLookaheadToken = this.lastConsumedToken;
            this.remainingLookahead = 3;
            this.hitFailure = false;
            this.scanToEnd = true;
            if (this.hitFailure || this.remainingLookahead <= 0) {
                this.lastLookaheadSucceeded = !this.hitFailure;
                boolean bl = this.lastLookaheadSucceeded;
                return bl;
            }
            this.pushOntoLookaheadStack("statement", "src\\main\\resources\\el.jj", 1480, 18);
            String prevProduction1336 = this.currentLookaheadProduction;
            this.currentLookaheadProduction = "assignmentExpr";
            this.scanToEnd = true;
            try {
                if (!this.check$assignmentExpr()) {
                    this.lastLookaheadSucceeded = false;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
                this.currentLookaheadProduction = prevProduction1336;
            }
            this.lastLookaheadSucceeded = true;
            boolean bl = true;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
            this.currentLookaheadToken = null;
        }
    }

    private final boolean check$argList() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("argList", "src\\main\\resources\\el.jj", 806, 2);
        String prevProduction1337 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "valueExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$valueExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1337;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1338 = this.currentLookaheadToken;
            if (this.check$el_jj$806$20()) continue;
            this.currentLookaheadToken = token1338;
            break;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$functionCall() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1339 = this.currentLookaheadToken;
        if (!this.check$el_jj$818$22()) {
            this.currentLookaheadToken = token1339;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.LEFT_PAREN)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1340 = this.currentLookaheadToken;
        if (!this.check$el_jj$818$64()) {
            this.currentLookaheadToken = token1340;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.RIGHT_PAREN)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$subExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.LEFT_PAREN)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("subExpr", "src\\main\\resources\\el.jj", 840, 15);
        String prevProduction1341 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "expr";
        this.scanToEnd = true;
        try {
            if (!this.check$expr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1341;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.RIGHT_PAREN)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$array() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.LEFT_SQ_BRACKET)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1342 = this.currentLookaheadToken;
        if (!this.check$el_jj$853$40()) {
            this.currentLookaheadToken = token1342;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.RIGHT_SQ_BRACKET)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$atomExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1343 = this.currentLookaheadToken;
        int remainingLookahead1343 = this.remainingLookahead;
        boolean hitFailure1343 = this.hitFailure;
        if (!this.scanToken(first_set$el_jj$867$5)) {
            this.currentLookaheadToken = token1343;
            this.remainingLookahead = remainingLookahead1343;
            this.hitFailure = hitFailure1343;
            if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                this.currentLookaheadToken = token1343;
                this.remainingLookahead = remainingLookahead1343;
                this.hitFailure = hitFailure1343;
                if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
                    this.currentLookaheadToken = token1343;
                    this.remainingLookahead = remainingLookahead1343;
                    this.hitFailure = hitFailure1343;
                    if (!this.check$el_jj$870$5()) {
                        this.currentLookaheadToken = token1343;
                        this.remainingLookahead = remainingLookahead1343;
                        this.hitFailure = hitFailure1343;
                        if (!this.check$el_jj$871$5()) {
                            this.currentLookaheadToken = token1343;
                            this.remainingLookahead = remainingLookahead1343;
                            this.hitFailure = hitFailure1343;
                            if (!this.scanToken(first_set$el_jj$872$5)) {
                                this.currentLookaheadToken = token1343;
                                this.remainingLookahead = remainingLookahead1343;
                                this.hitFailure = hitFailure1343;
                                if (!this.check$el_jj$873$5()) {
                                    this.currentLookaheadToken = token1343;
                                    this.remainingLookahead = remainingLookahead1343;
                                    this.hitFailure = hitFailure1343;
                                    this.lastLookaheadSucceeded = false;
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$notKeywordExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("notKeywordExpr", "src\\main\\resources\\el.jj", 884, 34);
        String prevProduction1344 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "atomExpr";
        this.scanToEnd = true;
        try {
            if (!this.check$atomExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1344;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$notExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.NOT)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("notExpr", "src\\main\\resources\\el.jj", 897, 19);
        String prevProduction1345 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "atomExpr";
        this.scanToEnd = true;
        try {
            if (!this.check$atomExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1345;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$singleExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1346 = this.currentLookaheadToken;
        int remainingLookahead1346 = this.remainingLookahead;
        boolean hitFailure1346 = this.hitFailure;
        if (!this.check$el_jj$909$4()) {
            this.currentLookaheadToken = token1346;
            this.remainingLookahead = remainingLookahead1346;
            this.hitFailure = hitFailure1346;
            if (!this.check$el_jj$910$6()) {
                this.currentLookaheadToken = token1346;
                this.remainingLookahead = remainingLookahead1346;
                this.hitFailure = hitFailure1346;
                if (!this.check$el_jj$911$6()) {
                    this.currentLookaheadToken = token1346;
                    this.remainingLookahead = remainingLookahead1346;
                    this.hitFailure = hitFailure1346;
                    this.lastLookaheadSucceeded = false;
                    return false;
                }
            }
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$customOp() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1347 = this.currentLookaheadToken;
        int remainingLookahead1347 = this.remainingLookahead;
        boolean hitFailure1347 = this.hitFailure;
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.currentLookaheadToken = token1347;
            this.remainingLookahead = remainingLookahead1347;
            this.hitFailure = hitFailure1347;
            if (!this.check$el_jj$925$5()) {
                this.currentLookaheadToken = token1347;
                this.remainingLookahead = remainingLookahead1347;
                this.hitFailure = hitFailure1347;
                if (!this.check$el_jj$926$5()) {
                    this.currentLookaheadToken = token1347;
                    this.remainingLookahead = remainingLookahead1347;
                    this.hitFailure = hitFailure1347;
                    this.lastLookaheadSucceeded = false;
                    return false;
                }
            }
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$unaryOrBinaryOrTernaryOp() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1348 = this.currentLookaheadToken;
        int remainingLookahead1348 = this.remainingLookahead;
        boolean hitFailure1348 = this.hitFailure;
        if (!this.check$el_jj$942$5()) {
            this.currentLookaheadToken = token1348;
            this.remainingLookahead = remainingLookahead1348;
            this.hitFailure = hitFailure1348;
            if (!this.check$el_jj$943$5()) {
                this.currentLookaheadToken = token1348;
                this.remainingLookahead = remainingLookahead1348;
                this.hitFailure = hitFailure1348;
                if (!this.check$el_jj$944$5()) {
                    this.currentLookaheadToken = token1348;
                    this.remainingLookahead = remainingLookahead1348;
                    this.hitFailure = hitFailure1348;
                    this.lastLookaheadSucceeded = false;
                    return false;
                }
            }
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$naryOp() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1349 = this.currentLookaheadToken;
        if (!this.check$el_jj$957$4()) {
            this.currentLookaheadToken = token1349;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$customOpExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("customOpExpr", "src\\main\\resources\\el.jj", 970, 3);
        String prevProduction1350 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "singleExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$singleExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1350;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("customOpExpr", "src\\main\\resources\\el.jj", 970, 22);
        String prevProduction1351 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "naryOp";
        this.scanToEnd = true;
        try {
            if (!this.check$naryOp()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1351;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$multExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("multExpr", "src\\main\\resources\\el.jj", 1026, 4);
        String prevProduction1352 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "customOpExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$customOpExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1352;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1353 = this.currentLookaheadToken;
            if (this.check$el_jj$1026$29()) continue;
            this.currentLookaheadToken = token1353;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$addExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("addExpr", "src\\main\\resources\\el.jj", 1070, 4);
        String prevProduction1354 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "multExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$multExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1354;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1355 = this.currentLookaheadToken;
            if (this.check$el_jj$1070$24()) continue;
            this.currentLookaheadToken = token1355;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$compExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("compExpr", "src\\main\\resources\\el.jj", 1165, 4);
        String prevProduction1356 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "addExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$addExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1356;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1357 = this.currentLookaheadToken;
        if (!this.check$el_jj$1165$24()) {
            this.currentLookaheadToken = token1357;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$andExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("andExpr", "src\\main\\resources\\el.jj", 1191, 4);
        String prevProduction1358 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "compExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$compExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1358;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1359 = this.currentLookaheadToken;
            if (this.check$el_jj$1191$28()) continue;
            this.currentLookaheadToken = token1359;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$orExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("orExpr", "src\\main\\resources\\el.jj", 1217, 4);
        String prevProduction1360 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "andExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$andExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1360;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1361 = this.currentLookaheadToken;
            if (this.check$el_jj$1217$27()) continue;
            this.currentLookaheadToken = token1361;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$valueExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("valueExpr", "src\\main\\resources\\el.jj", 1232, 2);
        String prevProduction1362 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "orExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$orExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1362;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$expr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("expr", "src\\main\\resources\\el.jj", 1239, 2);
        String prevProduction1363 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "valueExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$valueExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1363;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$condition() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("condition", "src\\main\\resources\\el.jj", 1247, 2);
        String prevProduction1364 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "valueExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$valueExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1364;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$thenExprBlock() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1365 = this.currentLookaheadToken;
        int remainingLookahead1365 = this.remainingLookahead;
        boolean hitFailure1365 = this.hitFailure;
        if (!this.check$el_jj$1258$4()) {
            this.currentLookaheadToken = token1365;
            this.remainingLookahead = remainingLookahead1365;
            this.hitFailure = hitFailure1365;
            if (!this.check$el_jj$1258$26()) {
                this.currentLookaheadToken = token1365;
                this.remainingLookahead = remainingLookahead1365;
                this.hitFailure = hitFailure1365;
                this.lastLookaheadSucceeded = false;
                return false;
            }
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$elseExprBlock() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1366 = this.currentLookaheadToken;
        int remainingLookahead1366 = this.remainingLookahead;
        boolean hitFailure1366 = this.hitFailure;
        if (!this.check$el_jj$1269$4()) {
            this.currentLookaheadToken = token1366;
            this.remainingLookahead = remainingLookahead1366;
            this.hitFailure = hitFailure1366;
            if (!this.check$el_jj$1269$26()) {
                this.currentLookaheadToken = token1366;
                this.remainingLookahead = remainingLookahead1366;
                this.hitFailure = hitFailure1366;
                this.lastLookaheadSucceeded = false;
                return false;
            }
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$elseifExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("elseifExpr", "src\\main\\resources\\el.jj", 1280, 18);
        String prevProduction1367 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "condition";
        this.scanToEnd = true;
        try {
            if (!this.check$condition()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1367;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("elseifExpr", "src\\main\\resources\\el.jj", 1280, 34);
        String prevProduction1368 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "thenExprBlock";
        this.scanToEnd = true;
        try {
            if (!this.check$thenExprBlock()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1368;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$elseifOptionalExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("elseifOptionalExpr", "src\\main\\resources\\el.jj", 1288, 37);
        String prevProduction1369 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "elseifExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$elseifExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1369;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$elseExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("elseExpr", "src\\main\\resources\\el.jj", 1296, 16);
        String prevProduction1370 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "elseExprBlock";
        this.scanToEnd = true;
        try {
            if (!this.check$elseExprBlock()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1370;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$elseOptionalExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("elseOptionalExpr", "src\\main\\resources\\el.jj", 1304, 35);
        String prevProduction1371 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "elseExpr";
        this.scanToEnd = false;
        try {
            if (!this.check$elseExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1371;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$elseOrElseifExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1372 = this.currentLookaheadToken;
            if (this.check$el_jj$1312$4()) continue;
            this.currentLookaheadToken = token1372;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1373 = this.currentLookaheadToken;
        if (!this.check$el_jj$1312$34()) {
            this.currentLookaheadToken = token1373;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$thenElseExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("thenElseExpr", "src\\main\\resources\\el.jj", 1319, 2);
        String prevProduction1374 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "thenExprBlock";
        this.scanToEnd = false;
        try {
            if (!this.check$thenExprBlock()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1374;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("thenElseExpr", "src\\main\\resources\\el.jj", 1319, 22);
        String prevProduction1375 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "elseOrElseifExpr";
        this.scanToEnd = true;
        try {
            if (!this.check$elseOrElseifExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1375;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$ifExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("ifExpr", "src\\main\\resources\\el.jj", 1328, 15);
        String prevProduction1376 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "condition";
        this.scanToEnd = true;
        try {
            if (!this.check$condition()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1376;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("ifExpr", "src\\main\\resources\\el.jj", 1328, 41);
        String prevProduction1377 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "thenElseExpr";
        this.scanToEnd = true;
        try {
            if (!this.check$thenElseExpr()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1377;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$caseClause() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(first_set$el_jj$1351$18)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.COLON)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("caseClause", "src\\main\\resources\\el.jj", 1351, 48);
        String prevProduction1378 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "block";
        this.scanToEnd = true;
        try {
            if (!this.check$block()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1378;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$defaultClause() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.COLON)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("defaultClause", "src\\main\\resources\\el.jj", 1362, 29);
        String prevProduction1379 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "block";
        this.scanToEnd = true;
        try {
            if (!this.check$block()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1379;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$caseOrDefaultClause() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1380 = this.currentLookaheadToken;
        int remainingLookahead1380 = this.remainingLookahead;
        boolean hitFailure1380 = this.hitFailure;
        if (!this.check$el_jj$1374$5()) {
            this.currentLookaheadToken = token1380;
            this.remainingLookahead = remainingLookahead1380;
            this.hitFailure = hitFailure1380;
            if (!this.check$el_jj$1375$5()) {
                this.currentLookaheadToken = token1380;
                this.remainingLookahead = remainingLookahead1380;
                this.hitFailure = hitFailure1380;
                this.lastLookaheadSucceeded = false;
                return false;
            }
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$caseOrDefaultClauses() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.LEFT_CURLY_BRACKET)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.check$el_jj$1385$3()) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1381 = this.currentLookaheadToken;
            if (this.check$el_jj$1385$3()) continue;
            this.currentLookaheadToken = token1381;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.RIGHT_CURLY_BRACKET)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$switchExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("switchExpr", "src\\main\\resources\\el.jj", 1396, 19);
        String prevProduction1382 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "condition";
        this.scanToEnd = true;
        try {
            if (!this.check$condition()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1382;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("switchExpr", "src\\main\\resources\\el.jj", 1396, 41);
        String prevProduction1383 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "caseOrDefaultClauses";
        this.scanToEnd = true;
        try {
            if (!this.check$caseOrDefaultClauses()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1383;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$assignmentLetExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.HPATH)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(first_set$el_jj$1434$16)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.EQ_1)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("assignmentLetExpr", "src\\main\\resources\\el.jj", 1434, 74);
        String prevProduction1384 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "assignmentExprContent";
        this.scanToEnd = true;
        try {
            if (!this.check$assignmentExprContent()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1384;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$assignmentExpr() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(first_set$el_jj$1450$3)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        if (!this.scanToken(ExprLangConstants.TokenType.EQ_1)) {
            this.lastLookaheadSucceeded = false;
            return false;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("assignmentExpr", "src\\main\\resources\\el.jj", 1450, 61);
        String prevProduction1385 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "assignmentExprContent";
        this.scanToEnd = true;
        try {
            if (!this.check$assignmentExprContent()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1385;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$assignmentExprContent() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1386 = this.currentLookaheadToken;
        int remainingLookahead1386 = this.remainingLookahead;
        boolean hitFailure1386 = this.hitFailure;
        if (!this.check$el_jj$1465$6()) {
            this.currentLookaheadToken = token1386;
            this.remainingLookahead = remainingLookahead1386;
            this.hitFailure = hitFailure1386;
            if (!this.check$el_jj$1466$6()) {
                this.currentLookaheadToken = token1386;
                this.remainingLookahead = remainingLookahead1386;
                this.hitFailure = hitFailure1386;
                if (!this.check$el_jj$1467$6()) {
                    this.currentLookaheadToken = token1386;
                    this.remainingLookahead = remainingLookahead1386;
                    this.hitFailure = hitFailure1386;
                    this.lastLookaheadSucceeded = false;
                    return false;
                }
            }
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$statement() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        Token token1387 = this.currentLookaheadToken;
        int remainingLookahead1387 = this.remainingLookahead;
        boolean hitFailure1387 = this.hitFailure;
        if (!this.check$el_jj$1477$5()) {
            this.currentLookaheadToken = token1387;
            this.remainingLookahead = remainingLookahead1387;
            this.hitFailure = hitFailure1387;
            if (!this.check$el_jj$1478$5()) {
                this.currentLookaheadToken = token1387;
                this.remainingLookahead = remainingLookahead1387;
                this.hitFailure = hitFailure1387;
                if (!this.check$el_jj$1479$5()) {
                    this.currentLookaheadToken = token1387;
                    this.remainingLookahead = remainingLookahead1387;
                    this.hitFailure = hitFailure1387;
                    if (!this.check$el_jj$1480$5()) {
                        this.currentLookaheadToken = token1387;
                        this.remainingLookahead = remainingLookahead1387;
                        this.hitFailure = hitFailure1387;
                        if (!this.check$el_jj$1481$5()) {
                            this.currentLookaheadToken = token1387;
                            this.remainingLookahead = remainingLookahead1387;
                            this.hitFailure = hitFailure1387;
                            this.lastLookaheadSucceeded = false;
                            return false;
                        }
                    }
                }
            }
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    private final boolean check$block() {
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.pushOntoLookaheadStack("block", "src\\main\\resources\\el.jj", 1490, 4);
        String prevProduction1388 = this.currentLookaheadProduction;
        this.currentLookaheadProduction = "statement";
        this.scanToEnd = false;
        try {
            if (!this.check$statement()) {
                this.lastLookaheadSucceeded = false;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
            this.currentLookaheadProduction = prevProduction1388;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        while (this.remainingLookahead > 0 && !this.hitFailure) {
            Token token1389 = this.currentLookaheadToken;
            if (this.check$el_jj$1490$27()) continue;
            this.currentLookaheadToken = token1389;
            break;
        }
        if (this.hitFailure || this.remainingLookahead <= 0) {
            this.lastLookaheadSucceeded = !this.hitFailure;
            return this.lastLookaheadSucceeded;
        }
        this.lastLookaheadSucceeded = true;
        return true;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.trace_enabled = tracingEnabled;
    }

    @Deprecated
    public void enable_tracing() {
        this.setTracingEnabled(true);
    }

    @Deprecated
    public void disable_tracing() {
        this.setTracingEnabled(false);
    }

    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        this.parsingStack.add(new NonTerminalCall(fileName, methodName, line, column));
    }

    private final void popCallStack() {
        NonTerminalCall ntc = this.parsingStack.remove(this.parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
        this.outerFollowSet = ntc.followSet;
    }

    private final void pushOntoLookaheadStack(String methodName, String fileName, int line, int column) {
        this.lookaheadStack.add(new NonTerminalCall(fileName, methodName, line, column));
    }

    private final void popLookaheadStack() {
        NonTerminalCall ntc = this.lookaheadStack.remove(this.lookaheadStack.size() - 1);
        this.currentLookaheadProduction = ntc.productionName;
        this.scanToEnd = ntc.scanToEnd;
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.lookaheadStack.listIterator(this.lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.parsingStack.listIterator(this.parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + this.currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + this.currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        this.dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        this.dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(ExprLangConstants.TokenType expectedType) throws ParseException {
        Token oldToken = this.lastConsumedToken;
        Token nextToken = this.nextToken(this.lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = this.handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        if (this.trace_enabled) {
            LOGGER.info("Consumed token of type " + (Object)((Object)this.lastConsumedToken.getType()) + " from " + this.lastConsumedToken.getLocation());
        }
        return this.lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(ExprLangConstants.TokenType expectedType, Token nextToken) throws ParseException {
        throw new ParseException(nextToken, EnumSet.of(expectedType), this.parsingStack);
    }

    public boolean isTreeBuildingEnabled() {
        return false;
    }

    private class ParseState {
        Token lastConsumed;
        ArrayList<NonTerminalCall> parsingStack;
        ExprLangConstants.LexicalState lexicalState;

        ParseState() {
            this.lastConsumed = ExprLangParser.this.lastConsumedToken;
            this.parsingStack = (ArrayList)ExprLangParser.this.parsingStack.clone();
            this.lexicalState = ExprLangParser.this.token_source.lexicalState;
        }
    }

    class NonTerminalCall {
        final String sourceFile;
        final String productionName;
        final int line;
        final int column;
        final boolean scanToEnd;
        final EnumSet<ExprLangConstants.TokenType> followSet;

        NonTerminalCall(String sourceFile, String productionName, int line, int column) {
            this.sourceFile = sourceFile;
            this.productionName = productionName;
            this.line = line;
            this.column = column;
            this.scanToEnd = ExprLangParser.this.scanToEnd;
            this.followSet = ExprLangParser.this.outerFollowSet;
        }

        StackTraceElement createStackTraceElement() {
            return new StackTraceElement(ExprLangParser.PARSER_NAME, this.productionName, this.sourceFile, this.line);
        }

        void dump(PrintStream ps) {
            ps.println(this.productionName + ":" + this.line + ":" + this.column);
        }
    }
}

