/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser.internal;

import java.util.ArrayList;
import java.util.List;
import org.talend.maplang.el.parser.DSELConstants;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.Location;
import org.talend.maplang.el.parser.ParserErrorMessageProvider;
import org.talend.maplang.el.parser.internal.ParseExceptionDetails;
import org.talend.maplang.el.parser.internal.ParsingContext;

public abstract class DefaultParserErrorMessageProvider
implements ParserErrorMessageProvider {
    protected static final String BOOLEAN_LITERAL = "BOOLEAN_LITERAL";
    protected static final String NULL_LITERAL = "NULL_LITERAL";
    protected static final String FUNCTION_CALL = "FUNCTION_CALL";
    protected static final String KEYWORD_PREFIX = "KEYWORD_";
    protected static final String OPERATOR_PREFIX = "OPERATOR_";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String NEW_LINE = "\n";

    protected abstract String getMessage(String var1, Object ... var2);

    @Override
    public String getErrorMessage(ParseExceptionDetails exceptionDetails, ParsingContext parsingContext, DslContent invalidDslContent) {
        return this.buildErrorMessage(exceptionDetails, parsingContext, invalidDslContent);
    }

    protected void handleLocation(StringBuilder buf, ParseExceptionDetails exceptionDetails, ParsingContext parsingContext, DslContent invalidDslContent) {
        Location location = exceptionDetails.getLastLocation();
        if (location != null && location.isValid()) {
            if (invalidDslContent.isEscaped()) {
                location = invalidDslContent.adapt(location);
            }
            buf.append(this.getMessage("errorLocation", location.getLine(), location.getColumn()));
            buf.append(SPACE);
            String invalidExpression = invalidDslContent.getOriginalContent();
            String lastValidReadCharacters = this.extract(invalidExpression, location);
            buf.append(this.getMessage("lastValidReadCharacters", lastValidReadCharacters));
            buf.append(SPACE);
        }
    }

    protected void handleInvalidToken(StringBuilder buf, ParseExceptionDetails exceptionDetails) {
        if (exceptionDetails.isInvalidToken()) {
            buf.append(this.getMessage("invalidToken", exceptionDetails.getTokenImage()));
            buf.append(SPACE);
        }
    }

    protected String buildErrorMessage(ParseExceptionDetails exceptionDetails, ParsingContext parsingContext, DslContent invalidDslContent) {
        StringBuilder buf = new StringBuilder();
        if (exceptionDetails.hasToken() || exceptionDetails.hasExpectedTokens()) {
            this.handleLocation(buf, exceptionDetails, parsingContext, invalidDslContent);
            this.handleInvalidToken(buf, exceptionDetails);
            List<String> expectedTokens = this.getExpectedTokens(exceptionDetails, parsingContext);
            boolean treated = false;
            if (expectedTokens.size() == 1 && this.isEndOfExpr(expectedTokens.get(0)) && exceptionDetails.hasNextToken()) {
                String nextTokenImage = exceptionDetails.getNextTokenImage();
                String nextTokenType = exceptionDetails.getNextTokenType();
                if (nextTokenImage != null && nextTokenType != null) {
                    if (this.isHPath(nextTokenType)) {
                        buf.append(this.getMessage("invalidNextHPath", nextTokenImage));
                    } else if (this.isOperator(nextTokenType)) {
                        buf.append(this.getMessage("invalidNextOperator", nextTokenImage));
                    } else if (this.isDot(nextTokenType)) {
                        if (this.isLastConsumedTokenHPath(exceptionDetails)) {
                            String invalidHPath = exceptionDetails.getLastConsumedTokenImage() + DSELConstants.DOT;
                            buf.append(this.getMessage("invalidHPath", invalidHPath));
                        } else {
                            buf.append(this.getMessage("invalidNextToken", nextTokenImage));
                        }
                    } else if (this.isOpeningArray(nextTokenType)) {
                        if (this.isLastConsumedTokenHPath(exceptionDetails)) {
                            String invalidHPath = exceptionDetails.getLastConsumedTokenImage() + DSELConstants.LEFT_SQ_BRACKET;
                            buf.append(this.getMessage("invalidHPath", invalidHPath));
                        } else {
                            buf.append(this.getMessage("invalidNextToken", nextTokenImage));
                        }
                    } else {
                        buf.append(this.getMessage("invalidNextToken", nextTokenImage));
                    }
                    treated = true;
                }
            }
            if (!treated && !expectedTokens.isEmpty()) {
                StringBuilder tokenBuf = new StringBuilder();
                this.appendExpectedTokens(tokenBuf, expectedTokens);
                buf.append(this.getMessage("expectedTokens", tokenBuf.toString()));
            }
        } else {
            buf.append(this.getMessage("parsingError", exceptionDetails.getMessage()));
        }
        return buf.toString();
    }

    protected List<String> getExpectedTokens(ParseExceptionDetails exceptionDetails, ParsingContext parsingContext) {
        ArrayList<String> result = new ArrayList<String>();
        boolean expectLiteral = false;
        boolean expectHPath = false;
        boolean expectEOF = false;
        List<String> expectedTokens = exceptionDetails.getExpectedTokens();
        if (expectedTokens != null) {
            for (String expectedToken : expectedTokens) {
                if (this.isOpeningArray(expectedToken)) continue;
                result.add(expectedToken);
                if (this.isLiteral(expectedToken)) {
                    expectLiteral = true;
                }
                if (this.isHPath(expectedToken)) {
                    expectHPath = true;
                }
                if (!this.isEndOfExpr(expectedToken)) continue;
                expectEOF = true;
            }
            if (expectLiteral) {
                result.add(BOOLEAN_LITERAL);
                result.add(NULL_LITERAL);
            }
            if (expectHPath && expectLiteral) {
                result.add(FUNCTION_CALL);
            }
            if (expectHPath && expectedTokens.size() == 1) {
                if (parsingContext.isExpectingKeyword()) {
                    this.addExpectedKeywords(parsingContext, result, true, false);
                } else if (parsingContext.isExpectingOperator()) {
                    this.addExpectedOperator(parsingContext, result, true, false);
                }
            }
            if (expectEOF && expectedTokens.size() == 1) {
                if (parsingContext.isExpectingKeyword()) {
                    this.addExpectedKeywords(parsingContext, result, false, true);
                } else if (parsingContext.isExpectingOperator()) {
                    this.addExpectedOperator(parsingContext, result, false, true);
                }
            }
        }
        return result;
    }

    protected void addExpectedOperator(ParsingContext parsingContext, List<String> result, boolean clear, boolean insert) {
        String expectedOperator;
        if (clear) {
            result.clear();
        }
        if ((expectedOperator = parsingContext.getExpectedOperator()) != null) {
            if (insert) {
                result.add(0, OPERATOR_PREFIX + expectedOperator);
            } else {
                result.add(OPERATOR_PREFIX + expectedOperator);
            }
        }
    }

    protected void addExpectedKeywords(ParsingContext parsingContext, List<String> result, boolean clear, boolean insert) {
        if (clear) {
            result.clear();
        }
        List<String> expectedKeywords = parsingContext.getExpectedKeywords();
        for (String expectedKeyword : expectedKeywords) {
            if (insert) {
                result.add(0, KEYWORD_PREFIX + expectedKeyword);
                continue;
            }
            result.add(KEYWORD_PREFIX + expectedKeyword);
        }
    }

    protected boolean isOpeningArray(String tokenType) {
        return DSELConstants.LEFT_SQ_BRACKET_TYPE.equals(tokenType);
    }

    protected boolean isLastConsumedTokenHPath(ParseExceptionDetails exceptionDetails) {
        return exceptionDetails.hasLastConsumedToken() && this.isHPath(exceptionDetails.getLastConsumedTokenType());
    }

    protected boolean isHPath(String tokenType) {
        return DSELConstants.HPATH_TYPE.equals(tokenType);
    }

    protected boolean isOperator(String tokenType) {
        for (String op_type : DSELConstants.OPERATOR_TYPES) {
            if (!op_type.equals(tokenType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLiteral(String tokenType) {
        for (String lit_type : DSELConstants.LITERAL_TYPES) {
            if (!lit_type.equals(tokenType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDot(String tokenType) {
        return DSELConstants.DOT_TYPE.equals(tokenType);
    }

    protected boolean isEndOfExpr(String tokenType) {
        return DSELConstants.EOF_TYPE.equals(tokenType);
    }

    protected String extract(String expression, Location location) {
        int lineIndex = location.getLine();
        int colIndex = location.getColumn();
        String[] exprLines = expression.split(NEW_LINE, -1);
        StringBuilder buf = new StringBuilder();
        if (lineIndex > 1) {
            buf.append(exprLines[lineIndex - 2]);
            buf.append(SPACE);
        }
        buf.append(exprLines[lineIndex - 1].substring(0, colIndex - 1));
        return buf.toString();
    }

    protected boolean isValidLocation(int[] location) {
        return location[0] >= 0 && location[1] >= 0;
    }

    protected void commaSpace(StringBuilder buf) {
        buf.append(COMMA);
        buf.append(SPACE);
    }

    protected void appendExpectedTokens(StringBuilder buf, List<String> tokens) {
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                this.commaSpace(buf);
            }
            buf.append(this.getMessage(token.toLowerCase(), new Object[0]));
            first = false;
        }
    }
}

