/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;
import org.talend.maplang.el.parser.model.ExprModelVisitor;

public abstract class BaseExprModelVisitor<T>
implements ExprModelVisitor<T> {
    private ConditionalExprVisitPolicy conditionalExprVisitPolicy;
    private DslContent dslContent;

    protected BaseExprModelVisitor() {
        this(ConditionalExprVisitPolicy.THEN);
    }

    protected BaseExprModelVisitor(ConditionalExprVisitPolicy conditionalExprVisitPolicy) {
        this.conditionalExprVisitPolicy = conditionalExprVisitPolicy;
    }

    @Override
    public void setDslContent(DslContent dslContent) {
        this.dslContent = dslContent;
    }

    protected DslContent getDslContent() {
        return this.dslContent;
    }

    @Override
    public T visitRoot(ELNode rootNode) {
        return this.visitChildren(rootNode);
    }

    @Override
    public T visitBlock(ELNode blockNode) {
        return this.visitChildren(blockNode);
    }

    @Override
    public T visitLiteral(ELNode literalNode) {
        return this.getDefaultValue();
    }

    @Override
    public T visitArray(ELNode arrayNode) {
        return this.visitChildren(arrayNode);
    }

    @Override
    public T visitCompOp(ELNode compOpNode) {
        return this.visitChildren(compOpNode);
    }

    @Override
    public T visitAddOp(ELNode addOpNode) {
        return this.visitChildren(addOpNode);
    }

    @Override
    public T visitMultOp(ELNode multOpNode) {
        return this.visitChildren(multOpNode);
    }

    @Override
    public T visitLogicalOp(ELNode logicalOpNode) {
        return this.visitChildren(logicalOpNode);
    }

    @Override
    public T visitNot(ELNode notNode) {
        return this.visitChildren(notNode);
    }

    @Override
    public T visitHPath(ELNode hPathNode) {
        return this.getDefaultValue();
    }

    @Override
    public T visitVariable(ELNode variableNode) {
        return this.getDefaultValue();
    }

    @Override
    public T visitFunctionCall(ELNode functionNode) {
        return this.visitChildren(functionNode);
    }

    @Override
    public T visitAssignment(ELNode assignNode) {
        return this.visitChildren(assignNode);
    }

    @Override
    public T visitIfThenElse(ELNode ifThenElseNode) {
        ArrayList<ELNode> nodes = new ArrayList<ELNode>();
        if (this.conditionalExprVisitPolicy.visitThen()) {
            nodes.addAll(ifThenElseNode.getChildren(ELNodeType.THEN).stream().map(n -> n.getChild(0)).collect(Collectors.toList()));
            if (ifThenElseNode.hasChildOfType(ELNodeType.ELSE)) {
                nodes.add(ifThenElseNode.getFirstChild(ELNodeType.ELSE).getChild(0));
            }
        }
        if (this.conditionalExprVisitPolicy.visitCondition()) {
            nodes.addAll(ifThenElseNode.getChildren(ELNodeType.CONDITION).stream().map(n -> n.getChild(0)).collect(Collectors.toList()));
        }
        return this.visitNodes(nodes);
    }

    @Override
    public T visitSwitchCases(ELNode switchNode) {
        ArrayList<ELNode> nodes = new ArrayList<ELNode>();
        if (this.conditionalExprVisitPolicy.visitThen()) {
            nodes.addAll(switchNode.getChildren(ELNodeType.CASE).stream().map(n -> n.getChild(1)).collect(Collectors.toList()));
            if (switchNode.hasChildOfType(ELNodeType.DEFAULT)) {
                nodes.add(switchNode.getFirstChild(ELNodeType.DEFAULT).getChild(0));
            }
        }
        if (this.conditionalExprVisitPolicy.visitCondition()) {
            nodes.add(switchNode.getFirstChild(ELNodeType.CONDITION).getChild(0));
        }
        return this.visitNodes(nodes);
    }

    protected T visitNodes(List<ELNode> nodes) {
        T value = this.getDefaultValue();
        for (ELNode node : nodes) {
            value = this.mergeValues(node.accept(this), value);
        }
        return value;
    }

    protected T visitChildren(ELNode node) {
        return this.visitNodes(node.getChildren());
    }

    protected abstract T getDefaultValue();

    protected abstract T mergeValues(T var1, T var2);

    public static enum ConditionalExprVisitPolicy {
        CONDITION,
        THEN,
        ALL;


        public boolean visitCondition() {
            return this == CONDITION || this == ALL;
        }

        public boolean visitThen() {
            return this == THEN || this == ALL;
        }
    }
}

