/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.converter.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.talend.trr.runtime.converter.Converter;
import org.talend.trr.runtime.converter.UnableToConvertException;
import org.talend.trr.runtime.converter.ValueFormat;

public abstract class NumberToDateTimeConverter<T>
implements Converter<Number, T> {
    protected List<ValueFormat> formats = Collections.singletonList(ValueFormat.MILLIS_SINCE_EPOCH);

    public Converter<Number, T> withFormats(List<ValueFormat> formats) {
        if (!CollectionUtils.isEmpty(formats)) {
            this.formats = formats;
        }
        return this;
    }

    protected void checkFormats() throws UnableToConvertException {
        if (CollectionUtils.isEmpty(this.formats)) {
            throw new UnableToConvertException("at least one format must be provided");
        }
    }

    protected void checkValue(Object value) throws UnableToConvertException {
        if (value == null) {
            throw new UnableToConvertException("empty value");
        }
    }

    protected T doConvert(Function<ValueFormat, T> convertFct) throws UnableToConvertException {
        return (T)this.formats.stream().map(convertFct).filter(Objects::nonNull).findFirst().orElseThrow(UnableToConvertException::new);
    }

    public static class NumberToDateTime
    extends NumberToDateTimeConverter<OffsetDateTime> {
        @Override
        public OffsetDateTime convert(Number value) throws UnableToConvertException {
            this.checkFormats();
            this.checkValue(value);
            return this.doConvert(format -> {
                if (format == ValueFormat.MILLIS_SINCE_EPOCH) {
                    return OffsetDateTime.ofInstant(Instant.ofEpochMilli(value.longValue()), ZoneOffset.UTC);
                }
                return null;
            });
        }
    }

    public static class NumberToTime
    extends NumberToDateTimeConverter<LocalTime> {
        @Override
        public LocalTime convert(Number value) throws UnableToConvertException {
            this.checkFormats();
            this.checkValue(value);
            return this.doConvert(format -> {
                if (format == ValueFormat.MILLIS_SINCE_DAYS_START) {
                    return LocalTime.ofNanoOfDay(value.longValue() * 1000000L);
                }
                if (format == ValueFormat.SECONDS_SINCE_DAYS_START) {
                    return LocalTime.ofSecondOfDay(value.longValue());
                }
                return null;
            });
        }
    }

    public static class NumberToDate
    extends NumberToDateTimeConverter<LocalDate> {
        @Override
        public LocalDate convert(Number value) throws UnableToConvertException {
            this.checkValue(value);
            return this.doConvert(format -> {
                if (format == ValueFormat.DAYS_SINCE_EPOCH) {
                    return LocalDate.ofEpochDay(value.longValue());
                }
                return Instant.ofEpochMilli(value.longValue()).atOffset(ZoneOffset.UTC).toLocalDate();
            });
        }
    }
}

